/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.aggregation.Aggregation;
import io.activej.aggregation.AggregationChunkStorage;
import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import io.activej.aggregation.AggregationQuery;
import io.activej.aggregation.AggregationState;
import io.activej.aggregation.AggregationStats;
import io.activej.aggregation.ChunkIdCodec;
import io.activej.aggregation.QueryException;
import io.activej.aggregation.fieldtype.FieldType;
import io.activej.aggregation.measure.Measure;
import io.activej.aggregation.ot.AggregationDiff;
import io.activej.aggregation.ot.AggregationStructure;
import io.activej.async.AsyncAccumulator;
import io.activej.async.function.AsyncSupplier;
import io.activej.codegen.ClassBuilder;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.ExpressionComparator;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Primitives;
import io.activej.common.Checks;
import io.activej.common.api.WithInitializer;
import io.activej.common.collection.CollectionUtils;
import io.activej.common.ref.Ref;
import io.activej.csp.process.frames.FrameFormat;
import io.activej.csp.process.frames.LZ4FrameFormat;
import io.activej.cube.ComputedMeasure;
import io.activej.cube.CubeClassLoaderCache;
import io.activej.cube.CubeQuery;
import io.activej.cube.ICube;
import io.activej.cube.QueryResult;
import io.activej.cube.ReportType;
import io.activej.cube.Utils;
import io.activej.cube.attributes.AttributeResolver;
import io.activej.cube.function.MeasuresFunction;
import io.activej.cube.function.RecordFunction;
import io.activej.cube.function.TotalsFunction;
import io.activej.cube.ot.CubeDiff;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamConsumerWithResult;
import io.activej.datastream.StreamDataAcceptor;
import io.activej.datastream.StreamSupplier;
import io.activej.datastream.processor.StreamFilter;
import io.activej.datastream.processor.StreamMapper;
import io.activej.datastream.processor.StreamReducer;
import io.activej.datastream.processor.StreamReducers;
import io.activej.datastream.processor.StreamSplitter;
import io.activej.datastream.processor.StreamSupplierTransformer;
import io.activej.etl.LogDataConsumer;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanEx;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.ValueStats;
import io.activej.ot.OTState;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.record.Record;
import io.activej.record.RecordScheme;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cube
implements ICube,
OTState<CubeDiff>,
WithInitializer<Cube>,
EventloopJmxBeanEx {
    private static final Logger logger = LoggerFactory.getLogger(Cube.class);
    public static final int DEFAULT_OVERLAPPING_CHUNKS_THRESHOLD = 300;
    public static final FrameFormat DEFAULT_SORT_FRAME_FORMAT = LZ4FrameFormat.create();
    private final Eventloop eventloop;
    private final Executor executor;
    private final DefiningClassLoader classLoader;
    private final AggregationChunkStorage aggregationChunkStorage;
    private FrameFormat sortFrameFormat = DEFAULT_SORT_FRAME_FORMAT;
    private Path temporarySortDir;
    private final Map<String, FieldType> fieldTypes = new LinkedHashMap<String, FieldType>();
    private final Map<String, FieldType> dimensionTypes = new LinkedHashMap<String, FieldType>();
    private final Map<String, Measure> measures = new LinkedHashMap<String, Measure>();
    private final Map<String, ComputedMeasure> computedMeasures = new LinkedHashMap<String, ComputedMeasure>();
    private final List<AttributeResolverContainer> attributeResolvers = new ArrayList<AttributeResolverContainer>();
    private final Map<String, Class<?>> attributeTypes = new LinkedHashMap();
    private final Map<String, AttributeResolverContainer> attributes = new LinkedHashMap<String, AttributeResolverContainer>();
    private final Map<String, String> childParentRelations = new LinkedHashMap<String, String>();
    private int aggregationsChunkSize = 1000000;
    private int aggregationsReducerBufferSize = 2000;
    private int aggregationsSorterItemsInMemory = 1000000;
    private int aggregationsMaxChunksToConsolidate = 1000;
    private boolean aggregationsIgnoreChunkReadingExceptions = false;
    private int maxOverlappingChunksToProcessLogs = 300;
    private Duration maxIncrementalReloadPeriod = Aggregation.DEFAULT_MAX_INCREMENTAL_RELOAD_PERIOD;
    private final Map<String, AggregationContainer> aggregations = new LinkedHashMap<String, AggregationContainer>();
    private CubeClassLoaderCache classLoaderCache;
    private final AggregationStats aggregationStats = new AggregationStats();
    private final ValueStats queryTimes = ValueStats.create((Duration)Duration.ofMinutes(10L));
    private long queryErrors;
    private Throwable queryLastError;

    Cube(Eventloop eventloop, Executor executor, DefiningClassLoader classLoader, AggregationChunkStorage aggregationChunkStorage) {
        this.eventloop = eventloop;
        this.executor = executor;
        this.classLoader = classLoader;
        this.aggregationChunkStorage = aggregationChunkStorage;
    }

    public static Cube create(@NotNull Eventloop eventloop, @NotNull Executor executor, @NotNull DefiningClassLoader classLoader, @NotNull AggregationChunkStorage aggregationChunkStorage) {
        return new Cube(eventloop, executor, classLoader, aggregationChunkStorage);
    }

    public Cube withAttribute(String attribute, AttributeResolver resolver) {
        Checks.checkArgument((!this.attributes.containsKey(attribute) ? 1 : 0) != 0, (String)"Attribute %s has already been defined", (Object[])new Object[]{attribute});
        int pos = attribute.indexOf(46);
        if (pos == -1) {
            throw new IllegalArgumentException("Attribute identifier is not split into name and dimension");
        }
        String dimension = attribute.substring(0, pos);
        String attributeName = attribute.substring(pos + 1);
        Checks.checkArgument((boolean)resolver.getAttributeTypes().containsKey(attributeName), (String)"Resolver does not support %s", (Object[])new Object[]{attribute});
        Checks.checkArgument((!Primitives.isWrapperType(resolver.getAttributeTypes().get(attributeName)) ? 1 : 0) != 0, (String)"Unsupported attribute type for %s", (Object[])new Object[]{attribute});
        List<String> dimensions = this.getAllParents(dimension);
        Checks.checkArgument((dimensions.size() == resolver.getKeyTypes().length ? 1 : 0) != 0, (String)"Parent dimensions: %s, key types: %s", (Object[])new Object[]{dimensions, Arrays.asList(resolver.getKeyTypes())});
        for (int i = 0; i < dimensions.size(); ++i) {
            String d = dimensions.get(i);
            Checks.checkArgument((boolean)this.dimensionTypes.get(d).getInternalDataType().equals(resolver.getKeyTypes()[i]), (String)"Dimension type mismatch for %s", (Object[])new Object[]{d});
        }
        AttributeResolverContainer resolverContainer = null;
        for (AttributeResolverContainer r : this.attributeResolvers) {
            if (r.resolver != resolver) continue;
            resolverContainer = r;
            break;
        }
        if (resolverContainer == null) {
            resolverContainer = new AttributeResolverContainer(dimensions, resolver);
            this.attributeResolvers.add(resolverContainer);
        }
        resolverContainer.attributes.add(attribute);
        this.attributes.put(attribute, resolverContainer);
        this.attributeTypes.put(attribute, resolver.getAttributeTypes().get(attributeName));
        return this;
    }

    public Cube withClassLoaderCache(CubeClassLoaderCache classLoaderCache) {
        this.classLoaderCache = classLoaderCache;
        return this;
    }

    public Cube withDimension(String dimensionId, FieldType type) {
        this.addDimension(dimensionId, type);
        return this;
    }

    public Cube withMeasure(String measureId, Measure measure) {
        this.addMeasure(measureId, measure);
        return this;
    }

    public Cube withComputedMeasure(String measureId, ComputedMeasure computedMeasure) {
        this.addComputedMeasure(measureId, computedMeasure);
        return this;
    }

    public Cube withRelation(String child, String parent) {
        this.addRelation(child, parent);
        return this;
    }

    public Cube withTemporarySortDir(Path temporarySortDir) {
        this.temporarySortDir = temporarySortDir;
        return this;
    }

    public Cube withSortFrameFormat(FrameFormat sortFrameFormat) {
        this.sortFrameFormat = sortFrameFormat;
        return this;
    }

    public Cube withAggregation(AggregationConfig aggregationConfig) {
        this.addAggregation(aggregationConfig);
        return this;
    }

    private static <K, V> Stream<Map.Entry<K, V>> filterEntryKeys(Stream<Map.Entry<K, V>> stream, Predicate<K> predicate) {
        return stream.filter(entry -> predicate.test(entry.getKey()));
    }

    public void addMeasure(String measureId, Measure measure) {
        Checks.checkState((boolean)this.aggregations.isEmpty(), (Object)"Cannot add measure while aggregations are present");
        this.measures.put(measureId, measure);
        this.fieldTypes.put(measureId, measure.getFieldType());
    }

    public void addComputedMeasure(String measureId, ComputedMeasure computedMeasure) {
        Checks.checkState((boolean)this.aggregations.isEmpty(), (Object)"Cannot add computed measure while aggregations are present");
        this.computedMeasures.put(measureId, computedMeasure);
    }

    public void addRelation(String child, String parent) {
        this.childParentRelations.put(child, parent);
    }

    public void addDimension(String dimensionId, FieldType type) {
        Checks.checkState((boolean)this.aggregations.isEmpty(), (Object)"Cannot add dimension while aggregations are present");
        this.dimensionTypes.put(dimensionId, type);
        this.fieldTypes.put(dimensionId, type);
    }

    public void addAggregation(AggregationConfig config) {
        Checks.checkArgument((!this.aggregations.containsKey(config.id) ? 1 : 0) != 0, (String)"Aggregation '%s' is already defined", (Object[])new Object[]{config.id});
        AggregationStructure structure = ((AggregationStructure)((AggregationStructure)((AggregationStructure)AggregationStructure.create((ChunkIdCodec)ChunkIdCodec.ofLong()).withInitializer(s -> config.dimensions.forEach(dimensionId -> s.withKey(dimensionId, this.dimensionTypes.get(dimensionId))))).withInitializer(s -> config.measures.forEach(measureId -> s.withMeasure(measureId, this.measures.get(measureId))))).withInitializer(s -> this.measures.forEach((measureId, measure) -> {
            if (!config.measures.contains(measureId)) {
                s.withIgnoredMeasure(measureId, measure.getFieldType());
            }
        }))).withPartitioningKey(config.partitioningKey);
        Aggregation aggregation = Aggregation.create((Eventloop)this.eventloop, (Executor)this.executor, (DefiningClassLoader)this.classLoader, (AggregationChunkStorage)this.aggregationChunkStorage, (FrameFormat)this.sortFrameFormat, (AggregationStructure)structure).withTemporarySortDir(this.temporarySortDir).withChunkSize(config.chunkSize != 0 ? config.chunkSize : this.aggregationsChunkSize).withReducerBufferSize(config.reducerBufferSize != 0 ? config.reducerBufferSize : this.aggregationsReducerBufferSize).withSorterItemsInMemory(config.sorterItemsInMemory != 0 ? config.sorterItemsInMemory : this.aggregationsSorterItemsInMemory).withMaxChunksToConsolidate(config.maxChunksToConsolidate != 0 ? config.maxChunksToConsolidate : this.aggregationsMaxChunksToConsolidate).withIgnoreChunkReadingExceptions(this.aggregationsIgnoreChunkReadingExceptions).withStats(this.aggregationStats);
        this.aggregations.put(config.id, new AggregationContainer(aggregation, config.measures, config.predicate));
        logger.info("Added aggregation {} for id '{}'", (Object)aggregation, (Object)config.id);
    }

    @NotNull
    public Class<?> getAttributeInternalType(String attribute) {
        if (this.dimensionTypes.containsKey(attribute)) {
            return this.dimensionTypes.get(attribute).getInternalDataType();
        }
        if (this.attributeTypes.containsKey(attribute)) {
            return this.attributeTypes.get(attribute);
        }
        throw new IllegalArgumentException("No attribute: " + attribute);
    }

    @NotNull
    public Class<?> getMeasureInternalType(String field) {
        if (this.measures.containsKey(field)) {
            return this.measures.get(field).getFieldType().getInternalDataType();
        }
        if (this.computedMeasures.containsKey(field)) {
            return this.computedMeasures.get(field).getType(this.measures);
        }
        throw new IllegalArgumentException("No measure: " + field);
    }

    @NotNull
    public Type getAttributeType(String attribute) {
        if (this.dimensionTypes.containsKey(attribute)) {
            return this.dimensionTypes.get(attribute).getDataType();
        }
        if (this.attributeTypes.containsKey(attribute)) {
            return this.attributeTypes.get(attribute);
        }
        throw new IllegalArgumentException("No attribute: " + attribute);
    }

    @NotNull
    public Type getMeasureType(String field) {
        if (this.measures.containsKey(field)) {
            return this.measures.get(field).getFieldType().getDataType();
        }
        if (this.computedMeasures.containsKey(field)) {
            return this.computedMeasures.get(field).getType(this.measures);
        }
        throw new IllegalArgumentException("No measure: " + field);
    }

    @Override
    public Map<String, Type> getAttributeTypes() {
        LinkedHashMap<String, Type> result = new LinkedHashMap<String, Type>();
        for (Map.Entry<String, FieldType> entry : this.dimensionTypes.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDataType());
        }
        result.putAll(this.attributeTypes);
        return result;
    }

    @Override
    public Map<String, Type> getMeasureTypes() {
        LinkedHashMap<String, Type> result = new LinkedHashMap<String, Type>();
        for (Map.Entry<String, Measure> entry : this.measures.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getFieldType().getDataType());
        }
        for (Map.Entry<String, Object> entry : this.computedMeasures.entrySet()) {
            result.put(entry.getKey(), ((ComputedMeasure)entry.getValue()).getType(this.measures));
        }
        return result;
    }

    public Aggregation getAggregation(String aggregationId) {
        return this.aggregations.get(aggregationId).aggregation;
    }

    public Set<String> getAggregationIds() {
        return this.aggregations.keySet();
    }

    public void init() {
        for (AggregationContainer container : this.aggregations.values()) {
            container.aggregation.getState().init();
        }
    }

    public void apply(CubeDiff op) {
        for (String aggregationId : op.keySet()) {
            AggregationDiff aggregationDiff = op.get(aggregationId);
            this.aggregations.get(aggregationId).aggregation.getState().apply(aggregationDiff);
        }
    }

    public <T> LogDataConsumer<T, CubeDiff> logStreamConsumer(Class<T> inputClass) {
        return this.logStreamConsumer(inputClass, AggregationPredicates.alwaysTrue());
    }

    public <T> LogDataConsumer<T, CubeDiff> logStreamConsumer(Class<T> inputClass, AggregationPredicate predicate) {
        return this.logStreamConsumer(inputClass, io.activej.aggregation.util.Utils.scanKeyFields(inputClass), io.activej.aggregation.util.Utils.scanMeasureFields(inputClass), predicate);
    }

    public <T> LogDataConsumer<T, CubeDiff> logStreamConsumer(Class<T> inputClass, Map<String, String> dimensionFields, Map<String, String> measureFields) {
        return this.logStreamConsumer(inputClass, dimensionFields, measureFields, AggregationPredicates.alwaysTrue());
    }

    public <T> LogDataConsumer<T, CubeDiff> logStreamConsumer(Class<T> inputClass, Map<String, String> dimensionFields, Map<String, String> measureFields, AggregationPredicate predicate) {
        return () -> this.consume(inputClass, dimensionFields, measureFields, predicate).transformResult(result -> result.map(Collections::singletonList));
    }

    public <T> StreamConsumerWithResult<T, CubeDiff> consume(Class<T> inputClass) {
        return this.consume(inputClass, AggregationPredicates.alwaysTrue());
    }

    public <T> StreamConsumerWithResult<T, CubeDiff> consume(Class<T> inputClass, AggregationPredicate predicate) {
        return this.consume(inputClass, io.activej.aggregation.util.Utils.scanKeyFields(inputClass), io.activej.aggregation.util.Utils.scanMeasureFields(inputClass), predicate);
    }

    public <T> StreamConsumerWithResult<T, CubeDiff> consume(Class<T> inputClass, Map<String, String> dimensionFields, Map<String, String> measureFields, AggregationPredicate dataPredicate) {
        logger.info("Started consuming data. Dimensions: {}. Measures: {}", dimensionFields.keySet(), measureFields.keySet());
        StreamSplitter streamSplitter = StreamSplitter.create((item, acceptors) -> {
            for (StreamDataAcceptor acceptor : acceptors) {
                acceptor.accept(item);
            }
        });
        AsyncAccumulator diffsAccumulator = AsyncAccumulator.create(new HashMap());
        Map<String, AggregationPredicate> compatibleAggregations = this.getCompatibleAggregationsForDataInput(dimensionFields, measureFields, dataPredicate);
        if (compatibleAggregations.size() == 0) {
            throw new IllegalArgumentException(String.format("No compatible aggregation for dimensions fields: %s, measureFields: %s", dimensionFields, measureFields));
        }
        for (Map.Entry<String, AggregationPredicate> aggregationToDataInputFilterPredicate : compatibleAggregations.entrySet()) {
            String aggregationId = aggregationToDataInputFilterPredicate.getKey();
            AggregationContainer aggregationContainer = this.aggregations.get(aggregationToDataInputFilterPredicate.getKey());
            Aggregation aggregation = aggregationContainer.aggregation;
            List keys = aggregation.getKeys();
            Map aggregationKeyFields = CollectionUtils.entriesToMap(Cube.filterEntryKeys(dimensionFields.entrySet().stream(), keys::contains));
            Map aggregationMeasureFields = CollectionUtils.entriesToMap(Cube.filterEntryKeys(measureFields.entrySet().stream(), aggregationContainer.measures::contains));
            AggregationPredicate dataInputFilterPredicate = aggregationToDataInputFilterPredicate.getValue();
            StreamSupplier output = streamSplitter.newOutput();
            if (!dataInputFilterPredicate.equals((Object)AggregationPredicates.alwaysTrue())) {
                Predicate filterPredicate = Cube.createFilterPredicate(inputClass, dataInputFilterPredicate, this.classLoader, this.fieldTypes);
                output = (StreamSupplier)output.transformWith((StreamSupplierTransformer)StreamFilter.create((Predicate)filterPredicate));
            }
            Promise consume = output.streamTo(aggregation.consume(inputClass, aggregationKeyFields, aggregationMeasureFields));
            diffsAccumulator.addPromise(consume, (accumulator, diff) -> accumulator.put(aggregationId, diff));
        }
        return StreamConsumerWithResult.of((StreamConsumer)streamSplitter.getInput(), (Promise)diffsAccumulator.run().promise().map(CubeDiff::of));
    }

    Map<String, AggregationPredicate> getCompatibleAggregationsForDataInput(Map<String, String> dimensionFields, Map<String, String> measureFields, AggregationPredicate predicate) {
        AggregationPredicate dataPredicate = predicate.simplify();
        HashMap<String, AggregationPredicate> aggregationToDataInputFilterPredicate = new HashMap<String, AggregationPredicate>();
        for (Map.Entry<String, AggregationContainer> aggregationContainer : this.aggregations.entrySet()) {
            Map aggregationMeasureFields;
            AggregationContainer container = aggregationContainer.getValue();
            Aggregation aggregation = container.aggregation;
            Set<String> dimensions = dimensionFields.keySet();
            if (!dimensions.containsAll(aggregation.getKeys()) || (aggregationMeasureFields = CollectionUtils.entriesToMap(Cube.filterEntryKeys(measureFields.entrySet().stream(), container.measures::contains))).isEmpty()) continue;
            AggregationPredicate containerPredicate = container.predicate.simplify();
            AggregationPredicate intersection = AggregationPredicates.and((AggregationPredicate[])new AggregationPredicate[]{containerPredicate, dataPredicate}).simplify();
            if (AggregationPredicates.alwaysFalse().equals((Object)intersection)) continue;
            if (intersection.equals((Object)containerPredicate)) {
                aggregationToDataInputFilterPredicate.put(aggregationContainer.getKey(), AggregationPredicates.alwaysTrue());
                continue;
            }
            aggregationToDataInputFilterPredicate.put(aggregationContainer.getKey(), containerPredicate);
        }
        return aggregationToDataInputFilterPredicate;
    }

    static Predicate createFilterPredicate(Class<?> inputClass, AggregationPredicate predicate, DefiningClassLoader classLoader, Map<String, FieldType> keyTypes) {
        return (Predicate)ClassBuilder.create((DefiningClassLoader)classLoader, Predicate.class, (Class[])new Class[0]).withClassKey(new Object[]{inputClass, predicate}).withMethod("test", Boolean.TYPE, Collections.singletonList(Object.class), predicate.createPredicate(Expressions.cast((Expression)Expressions.arg((int)0), inputClass), keyTypes)).buildClassAndCreateNewInstance();
    }

    public <T> StreamSupplier<T> queryRawStream(List<String> dimensions, List<String> storedMeasures, AggregationPredicate where, Class<T> resultClass) {
        return this.queryRawStream(dimensions, storedMeasures, where, resultClass, this.classLoader);
    }

    public <T> StreamSupplier<T> queryRawStream(List<String> dimensions, List<String> storedMeasures, AggregationPredicate where, Class<T> resultClass, DefiningClassLoader queryClassLoader) {
        List<AggregationContainer> compatibleAggregations = this.getCompatibleAggregationsForQuery(dimensions, storedMeasures, where);
        return this.queryRawStream(dimensions, storedMeasures, where, resultClass, queryClassLoader, compatibleAggregations);
    }

    private <T, K extends Comparable, S, A> StreamSupplier<T> queryRawStream(List<String> dimensions, List<String> storedMeasures, AggregationPredicate where, Class<T> resultClass, DefiningClassLoader queryClassLoader, List<AggregationContainer> compatibleAggregations) {
        ArrayList<AggregationContainerWithScore> containerWithScores = new ArrayList<AggregationContainerWithScore>();
        for (AggregationContainer compatibleAggregation : compatibleAggregations) {
            AggregationQuery aggregationQuery = AggregationQuery.create(dimensions, storedMeasures, (AggregationPredicate)where);
            double score = compatibleAggregation.aggregation.estimateCost(aggregationQuery);
            containerWithScores.add(new AggregationContainerWithScore(compatibleAggregation, score));
        }
        Collections.sort(containerWithScores);
        Class resultKeyClass = io.activej.aggregation.util.Utils.createKeyClass((Map)CollectionUtils.keysToMap(dimensions.stream(), this.dimensionTypes::get), (DefiningClassLoader)queryClassLoader);
        StreamReducer streamReducer = StreamReducer.create(Comparable::compareTo);
        StreamSupplier queryResultSupplier = streamReducer.getOutput();
        storedMeasures = new ArrayList<String>(storedMeasures);
        for (AggregationContainerWithScore aggregationContainerWithScore : containerWithScores) {
            AggregationContainer aggregationContainer = aggregationContainerWithScore.aggregationContainer;
            List compatibleMeasures = storedMeasures.stream().filter(aggregationContainer.measures::contains).collect(Collectors.toList());
            if (compatibleMeasures.isEmpty()) continue;
            storedMeasures.removeAll(compatibleMeasures);
            Class aggregationClass = io.activej.aggregation.util.Utils.createRecordClass((Map)CollectionUtils.keysToMap(dimensions.stream(), this.dimensionTypes::get), (Map)CollectionUtils.keysToMap(compatibleMeasures.stream(), m -> this.measures.get(m).getFieldType()), (DefiningClassLoader)queryClassLoader);
            StreamSupplier aggregationSupplier = aggregationContainer.aggregation.query(AggregationQuery.create(dimensions, compatibleMeasures, (AggregationPredicate)where), aggregationClass, queryClassLoader);
            if (storedMeasures.isEmpty() && streamReducer.getInputs().isEmpty()) {
                Function mapper = io.activej.aggregation.util.Utils.createMapper((Class)aggregationClass, resultClass, dimensions, compatibleMeasures, (DefiningClassLoader)queryClassLoader);
                queryResultSupplier = (StreamSupplier)aggregationSupplier.transformWith((StreamSupplierTransformer)StreamMapper.create((Function)mapper));
                break;
            }
            Function keyFunction = io.activej.aggregation.util.Utils.createKeyFunction((Class)aggregationClass, (Class)resultKeyClass, dimensions, (DefiningClassLoader)queryClassLoader);
            StreamReducers.Reducer reducer = aggregationContainer.aggregation.aggregationReducer(aggregationClass, resultClass, dimensions, compatibleMeasures, queryClassLoader);
            StreamConsumer streamReducerInput = streamReducer.newInput(keyFunction, reducer);
            aggregationSupplier.streamTo(streamReducerInput);
        }
        return queryResultSupplier;
    }

    List<AggregationContainer> getCompatibleAggregationsForQuery(Collection<String> dimensions, Collection<String> storedMeasures, AggregationPredicate where) {
        where = where.simplify();
        List allDimensions = Stream.concat(dimensions.stream(), where.getDimensions().stream()).collect(Collectors.toList());
        ArrayList<AggregationContainer> compatibleAggregations = new ArrayList<AggregationContainer>();
        for (AggregationContainer aggregationContainer : this.aggregations.values()) {
            AggregationPredicate intersection;
            List compatibleMeasures;
            List keys = aggregationContainer.aggregation.getKeys();
            if (!keys.containsAll(allDimensions) || (compatibleMeasures = storedMeasures.stream().filter(aggregationContainer.measures::contains).collect(Collectors.toList())).isEmpty() || !(intersection = AggregationPredicates.and((AggregationPredicate[])new AggregationPredicate[]{where, aggregationContainer.predicate}).simplify()).equals((Object)where)) continue;
            compatibleAggregations.add(aggregationContainer);
        }
        return compatibleAggregations;
    }

    public boolean containsExcessiveNumberOfOverlappingChunks() {
        boolean excessive = false;
        for (AggregationContainer aggregationContainer : this.aggregations.values()) {
            int numberOfOverlappingChunks = aggregationContainer.aggregation.getNumberOfOverlappingChunks();
            if (numberOfOverlappingChunks <= this.maxOverlappingChunksToProcessLogs) continue;
            logger.info("Aggregation {} contains {} overlapping chunks", (Object)aggregationContainer.aggregation, (Object)numberOfOverlappingChunks);
            excessive = true;
        }
        return excessive;
    }

    public Promise<CubeDiff> consolidate(Function<Aggregation, Promise<AggregationDiff>> strategy) {
        logger.info("Launching consolidation");
        HashMap map = new HashMap();
        ArrayList<AsyncSupplier> runnables = new ArrayList<AsyncSupplier>();
        for (Map.Entry<String, AggregationContainer> entry : this.aggregations.entrySet()) {
            String aggregationId = entry.getKey();
            Aggregation aggregation = entry.getValue().aggregation;
            runnables.add(() -> ((Promise)strategy.apply(aggregation)).whenResult(aggregationDiff -> {
                if (!aggregationDiff.isEmpty()) {
                    map.put(aggregationId, aggregationDiff);
                }
            }).toVoid());
        }
        return Promises.sequence(runnables).map($ -> CubeDiff.of(map));
    }

    private List<String> getAllParents(String dimension) {
        String parent;
        ArrayList<String> chain = new ArrayList<String>();
        chain.add(dimension);
        String child = dimension;
        while ((parent = this.childParentRelations.get(child)) != null) {
            chain.add(0, parent);
            child = parent;
        }
        return chain;
    }

    public Set<Object> getAllChunks() {
        HashSet<Object> chunks = new HashSet<Object>();
        for (AggregationContainer container : this.aggregations.values()) {
            chunks.addAll(container.aggregation.getState().getChunks().keySet());
        }
        return chunks;
    }

    public Map<String, List<AggregationState.ConsolidationDebugInfo>> getConsolidationDebugInfo() {
        HashMap<String, List<AggregationState.ConsolidationDebugInfo>> m = new HashMap<String, List<AggregationState.ConsolidationDebugInfo>>();
        for (Map.Entry<String, AggregationContainer> aggregationEntry : this.aggregations.entrySet()) {
            m.put(aggregationEntry.getKey(), aggregationEntry.getValue().aggregation.getState().getConsolidationDebugInfo());
        }
        return m;
    }

    public DefiningClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Promise<QueryResult> query(CubeQuery cubeQuery) throws QueryException {
        DefiningClassLoader queryClassLoader = this.getQueryClassLoader(new CubeClassLoaderCache.Key(new LinkedHashSet<String>(cubeQuery.getAttributes()), new LinkedHashSet<String>(cubeQuery.getMeasures()), cubeQuery.getWhere().getDimensions()));
        long queryStarted = this.eventloop.currentTimeMillis();
        return new RequestContext().execute(queryClassLoader, cubeQuery).whenComplete((queryResult, e) -> {
            if (e == null) {
                this.queryTimes.recordValue((int)(this.eventloop.currentTimeMillis() - queryStarted));
            } else {
                ++this.queryErrors;
                this.queryLastError = e;
                if (e instanceof NoSuchFileException) {
                    logger.warn("Query failed because of NoSuchFileException. " + cubeQuery.toString(), e);
                }
            }
        });
    }

    private DefiningClassLoader getQueryClassLoader(CubeClassLoaderCache.Key key) {
        if (this.classLoaderCache == null) {
            return this.classLoader;
        }
        return this.classLoaderCache.getOrCreate(key);
    }

    public String toString() {
        return "Cube{aggregations=" + this.aggregations + '}';
    }

    @JmxAttribute
    public int getAggregationsChunkSize() {
        return this.aggregationsChunkSize;
    }

    @JmxAttribute
    public void setAggregationsChunkSize(int aggregationsChunkSize) {
        this.aggregationsChunkSize = aggregationsChunkSize;
        for (AggregationContainer aggregationContainer : this.aggregations.values()) {
            aggregationContainer.aggregation.setChunkSize(aggregationsChunkSize);
        }
    }

    public Cube withAggregationsChunkSize(int aggregationsChunkSize) {
        this.aggregationsChunkSize = aggregationsChunkSize;
        return this;
    }

    public Cube withAggregationsReducerBufferSize(int aggregationsReducerBufferSize) {
        this.aggregationsReducerBufferSize = aggregationsReducerBufferSize;
        return this;
    }

    @JmxAttribute
    public int getAggregationsSorterItemsInMemory() {
        return this.aggregationsSorterItemsInMemory;
    }

    @JmxAttribute
    public void setAggregationsSorterItemsInMemory(int aggregationsSorterItemsInMemory) {
        this.aggregationsSorterItemsInMemory = aggregationsSorterItemsInMemory;
        for (AggregationContainer aggregationContainer : this.aggregations.values()) {
            aggregationContainer.aggregation.setSorterItemsInMemory(aggregationsSorterItemsInMemory);
        }
    }

    public Cube withAggregationsSorterItemsInMemory(int aggregationsSorterItemsInMemory) {
        this.aggregationsSorterItemsInMemory = aggregationsSorterItemsInMemory;
        return this;
    }

    @JmxAttribute
    public int getAggregationsMaxChunksToConsolidate() {
        return this.aggregationsMaxChunksToConsolidate;
    }

    @JmxAttribute
    public void setAggregationsMaxChunksToConsolidate(int aggregationsMaxChunksToConsolidate) {
        this.aggregationsMaxChunksToConsolidate = aggregationsMaxChunksToConsolidate;
        for (AggregationContainer aggregationContainer : this.aggregations.values()) {
            aggregationContainer.aggregation.setMaxChunksToConsolidate(aggregationsMaxChunksToConsolidate);
        }
    }

    public Cube withAggregationsMaxChunksToConsolidate(int aggregationsMaxChunksToConsolidate) {
        this.aggregationsMaxChunksToConsolidate = aggregationsMaxChunksToConsolidate;
        return this;
    }

    @JmxAttribute
    public boolean getAggregationsIgnoreChunkReadingExceptions() {
        return this.aggregationsIgnoreChunkReadingExceptions;
    }

    @JmxAttribute
    public void setAggregationsIgnoreChunkReadingExceptions(boolean aggregationsIgnoreChunkReadingExceptions) {
        this.aggregationsIgnoreChunkReadingExceptions = aggregationsIgnoreChunkReadingExceptions;
        for (AggregationContainer aggregation : this.aggregations.values()) {
            aggregation.aggregation.setIgnoreChunkReadingExceptions(aggregationsIgnoreChunkReadingExceptions);
        }
    }

    public Cube withAggregationsIgnoreChunkReadingExceptions(boolean aggregationsIgnoreChunkReadingExceptions) {
        this.aggregationsIgnoreChunkReadingExceptions = aggregationsIgnoreChunkReadingExceptions;
        return this;
    }

    @JmxAttribute
    public int getMaxOverlappingChunksToProcessLogs() {
        return this.maxOverlappingChunksToProcessLogs;
    }

    @JmxAttribute
    public void setMaxOverlappingChunksToProcessLogs(int maxOverlappingChunksToProcessLogs) {
        this.maxOverlappingChunksToProcessLogs = maxOverlappingChunksToProcessLogs;
    }

    public Cube withMaxOverlappingChunksToProcessLogs(int maxOverlappingChunksToProcessLogs) {
        this.maxOverlappingChunksToProcessLogs = maxOverlappingChunksToProcessLogs;
        return this;
    }

    @JmxAttribute
    public Duration getMaxIncrementalReloadPeriod() {
        return this.maxIncrementalReloadPeriod;
    }

    @JmxAttribute
    public void setMaxIncrementalReloadPeriod(Duration maxIncrementalReloadPeriod) {
        this.maxIncrementalReloadPeriod = maxIncrementalReloadPeriod;
    }

    public Cube withMaxIncrementalReloadPeriod(Duration maxIncrementalReloadPeriod) {
        this.maxIncrementalReloadPeriod = maxIncrementalReloadPeriod;
        return this;
    }

    @JmxAttribute
    public ValueStats getQueryTimes() {
        return this.queryTimes;
    }

    @JmxAttribute
    public long getQueryErrors() {
        return this.queryErrors;
    }

    @JmxAttribute
    public Throwable getQueryLastError() {
        return this.queryLastError;
    }

    @JmxAttribute
    public AggregationStats getAggregationStats() {
        return this.aggregationStats;
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    private static final class AttributeResolverContainer {
        private final List<String> attributes = new ArrayList<String>();
        private final List<String> dimensions;
        private final AttributeResolver resolver;

        private AttributeResolverContainer(List<String> dimensions, AttributeResolver resolver) {
            this.dimensions = dimensions;
            this.resolver = resolver;
        }
    }

    public static final class AggregationConfig
    implements WithInitializer<AggregationConfig> {
        private final String id;
        private final List<String> dimensions = new ArrayList<String>();
        private final List<String> measures = new ArrayList<String>();
        private AggregationPredicate predicate = AggregationPredicates.alwaysTrue();
        private final List<String> partitioningKey = new ArrayList<String>();
        private int chunkSize;
        private int reducerBufferSize;
        private int sorterItemsInMemory;
        private int maxChunksToConsolidate;

        public AggregationConfig(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static AggregationConfig id(String id) {
            return new AggregationConfig(id);
        }

        public AggregationConfig withDimensions(Collection<String> dimensions) {
            this.dimensions.addAll(dimensions);
            return this;
        }

        public AggregationConfig withDimensions(String ... dimensions) {
            return this.withDimensions(Arrays.asList(dimensions));
        }

        public AggregationConfig withMeasures(Collection<String> measures) {
            this.measures.addAll(measures);
            return this;
        }

        public AggregationConfig withMeasures(String ... measures) {
            return this.withMeasures(Arrays.asList(measures));
        }

        public AggregationConfig withPredicate(AggregationPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public AggregationConfig withPartitioningKey(List<String> partitioningKey) {
            this.partitioningKey.addAll(partitioningKey);
            return this;
        }

        public AggregationConfig withPartitioningKey(String ... partitioningKey) {
            this.partitioningKey.addAll(Arrays.asList(partitioningKey));
            return this;
        }

        public AggregationConfig withChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public AggregationConfig withReducerBufferSize(int reducerBufferSize) {
            this.reducerBufferSize = reducerBufferSize;
            return this;
        }

        public AggregationConfig withSorterItemsInMemory(int sorterItemsInMemory) {
            this.sorterItemsInMemory = sorterItemsInMemory;
            return this;
        }

        public AggregationConfig withMaxChunksToConsolidate(int maxChunksToConsolidate) {
            this.maxChunksToConsolidate = maxChunksToConsolidate;
            return this;
        }
    }

    static final class AggregationContainer {
        private final Aggregation aggregation;
        private final List<String> measures;
        private final AggregationPredicate predicate;

        private AggregationContainer(Aggregation aggregation, List<String> measures, AggregationPredicate predicate) {
            this.aggregation = aggregation;
            this.measures = measures;
            this.predicate = predicate;
        }

        public String toString() {
            return this.aggregation.toString();
        }
    }

    static class AggregationContainerWithScore
    implements Comparable<AggregationContainerWithScore> {
        final AggregationContainer aggregationContainer;
        final double score;

        private AggregationContainerWithScore(AggregationContainer aggregationContainer, double score) {
            this.score = score;
            this.aggregationContainer = aggregationContainer;
        }

        @Override
        public int compareTo(@NotNull AggregationContainerWithScore o) {
            int result = -Integer.compare(this.aggregationContainer.measures.size(), o.aggregationContainer.measures.size());
            if (result != 0) {
                return result;
            }
            result = Double.compare(this.score, o.score);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this.aggregationContainer.aggregation.getChunks(), o.aggregationContainer.aggregation.getChunks());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this.aggregationContainer.aggregation.getKeys().size(), o.aggregationContainer.aggregation.getKeys().size());
            return result;
        }
    }

    private class RequestContext<R> {
        DefiningClassLoader queryClassLoader;
        CubeQuery query;
        AggregationPredicate queryPredicate;
        AggregationPredicate queryHaving;
        List<AggregationContainer> compatibleAggregations = new ArrayList<AggregationContainer>();
        Map<String, Object> fullySpecifiedDimensions;
        final Set<String> resultDimensions = new LinkedHashSet<String>();
        final Set<String> resultAttributes = new LinkedHashSet<String>();
        final Set<String> resultMeasures = new LinkedHashSet<String>();
        final Set<String> resultStoredMeasures = new LinkedHashSet<String>();
        final Set<String> resultComputedMeasures = new LinkedHashSet<String>();
        Class<R> resultClass;
        Predicate<R> havingPredicate;
        final List<String> resultOrderings = new ArrayList<String>();
        Comparator<R> comparator;
        MeasuresFunction<R> measuresFunction;
        TotalsFunction<R, R> totalsFunction;
        final List<String> recordAttributes = new ArrayList<String>();
        final List<String> recordMeasures = new ArrayList<String>();
        RecordScheme recordScheme;
        RecordFunction recordFunction;

        private RequestContext() {
        }

        Promise<QueryResult> execute(DefiningClassLoader queryClassLoader, CubeQuery query) throws QueryException {
            this.queryClassLoader = queryClassLoader;
            this.query = query;
            this.queryPredicate = query.getWhere().simplify();
            this.queryHaving = query.getHaving().simplify();
            this.fullySpecifiedDimensions = this.queryPredicate.getFullySpecifiedDimensions();
            this.prepareDimensions();
            this.prepareMeasures();
            this.resultClass = Utils.createResultClass(this.resultAttributes, this.resultMeasures, Cube.this, queryClassLoader);
            this.recordScheme = this.createRecordScheme();
            if (query.getReportType() == ReportType.METADATA) {
                return Promise.of((Object)QueryResult.createForMetadata(this.recordScheme, this.recordAttributes, this.recordMeasures));
            }
            this.measuresFunction = this.createMeasuresFunction();
            this.totalsFunction = this.createTotalsFunction();
            this.comparator = this.createComparator();
            this.havingPredicate = this.createHavingPredicate();
            this.recordFunction = this.createRecordFunction();
            return Cube.this.queryRawStream(new ArrayList<String>(this.resultDimensions), new ArrayList<String>(this.resultStoredMeasures), this.queryPredicate, this.resultClass, queryClassLoader, this.compatibleAggregations).toList().then(this::processResults);
        }

        void prepareDimensions() throws QueryException {
            for (String attribute : this.query.getAttributes()) {
                this.recordAttributes.add(attribute);
                List dimensions = new ArrayList();
                if (Cube.this.dimensionTypes.containsKey(attribute)) {
                    dimensions = Cube.this.getAllParents(attribute);
                } else if (Cube.this.attributes.containsKey(attribute)) {
                    AttributeResolverContainer resolverContainer = (AttributeResolverContainer)Cube.this.attributes.get(attribute);
                    for (String dimension : resolverContainer.dimensions) {
                        dimensions.addAll(Cube.this.getAllParents(dimension));
                    }
                } else {
                    throw new QueryException("Attribute not found: " + attribute);
                }
                this.resultDimensions.addAll(dimensions);
                this.resultAttributes.addAll(dimensions);
                this.resultAttributes.add(attribute);
            }
        }

        void prepareMeasures() {
            HashSet<String> queryStoredMeasures = new HashSet<String>();
            for (String measure : this.query.getMeasures()) {
                if (Cube.this.computedMeasures.containsKey(measure)) {
                    queryStoredMeasures.addAll(((ComputedMeasure)Cube.this.computedMeasures.get(measure)).getMeasureDependencies());
                    continue;
                }
                if (!Cube.this.measures.containsKey(measure)) continue;
                queryStoredMeasures.add(measure);
            }
            this.compatibleAggregations = Cube.this.getCompatibleAggregationsForQuery(this.resultDimensions, queryStoredMeasures, this.queryPredicate);
            LinkedHashSet<String> compatibleMeasures = new LinkedHashSet<String>();
            for (AggregationContainer aggregationContainer : this.compatibleAggregations) {
                compatibleMeasures.addAll(aggregationContainer.measures);
            }
            for (Map.Entry entry : Cube.this.computedMeasures.entrySet()) {
                if (!compatibleMeasures.containsAll(((ComputedMeasure)entry.getValue()).getMeasureDependencies())) continue;
                compatibleMeasures.add((String)entry.getKey());
            }
            for (String string : this.query.getMeasures()) {
                if (!compatibleMeasures.contains(string) || this.recordMeasures.contains(string)) continue;
                this.recordMeasures.add(string);
                if (Cube.this.measures.containsKey(string)) {
                    this.resultStoredMeasures.add(string);
                    this.resultMeasures.add(string);
                    continue;
                }
                if (!Cube.this.computedMeasures.containsKey(string)) continue;
                ComputedMeasure expression = (ComputedMeasure)Cube.this.computedMeasures.get(string);
                Set<String> dependencies = expression.getMeasureDependencies();
                this.resultStoredMeasures.addAll(dependencies);
                this.resultComputedMeasures.add(string);
                this.resultMeasures.addAll(dependencies);
                this.resultMeasures.add(string);
            }
        }

        RecordScheme createRecordScheme() {
            RecordScheme recordScheme = RecordScheme.create((DefiningClassLoader)Cube.this.classLoader);
            for (String attribute : this.recordAttributes) {
                recordScheme.addField(attribute, Cube.this.getAttributeType(attribute));
            }
            for (String measure : this.recordMeasures) {
                recordScheme.addField(measure, Cube.this.getMeasureType(measure));
            }
            recordScheme.build();
            return recordScheme;
        }

        RecordFunction createRecordFunction() {
            return (RecordFunction)ClassBuilder.create((DefiningClassLoader)this.queryClassLoader, RecordFunction.class, (Class[])new Class[0]).withClassKey(new Object[]{this.resultClass, this.recordScheme.getFields()}).withMethod("copyAttributes", Expressions.sequence(expressions -> {
                for (String field : this.recordScheme.getFields()) {
                    int fieldIndex = this.recordScheme.getFieldIndex(field);
                    if (!Cube.this.dimensionTypes.containsKey(field)) continue;
                    expressions.add(Expressions.call((Expression)Expressions.arg((int)1), (String)"set", (Expression[])new Expression[]{Expressions.value((Object)fieldIndex), Expressions.cast((Expression)((FieldType)Cube.this.dimensionTypes.get(field)).toValue((Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field)), Object.class)}));
                }
            })).withMethod("copyMeasures", Expressions.sequence(expressions -> {
                for (String field : this.recordScheme.getFields()) {
                    int fieldIndex = this.recordScheme.getFieldIndex(field);
                    if (Cube.this.dimensionTypes.containsKey(field)) continue;
                    if (Cube.this.measures.containsKey(field)) {
                        Variable fieldValue = Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field);
                        expressions.add(Expressions.call((Expression)Expressions.arg((int)1), (String)"set", (Expression[])new Expression[]{Expressions.value((Object)fieldIndex), Expressions.cast((Expression)((Measure)Cube.this.measures.get(field)).getFieldType().toValue(((Measure)Cube.this.measures.get(field)).valueOfAccumulator((Expression)fieldValue)), Object.class)}));
                        continue;
                    }
                    expressions.add(Expressions.call((Expression)Expressions.arg((int)1), (String)"set", (Expression[])new Expression[]{Expressions.value((Object)fieldIndex), Expressions.cast((Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field.replace('.', '$')), Object.class)}));
                }
            })).buildClassAndCreateNewInstance();
        }

        MeasuresFunction<R> createMeasuresFunction() {
            return (MeasuresFunction)((ClassBuilder)ClassBuilder.create((DefiningClassLoader)this.queryClassLoader, MeasuresFunction.class, (Class[])new Class[0]).withClassKey(new Object[]{this.resultClass, this.resultComputedMeasures}).withInitializer(cb -> this.resultComputedMeasures.forEach(computedMeasure -> cb.withField(computedMeasure, ((ComputedMeasure)Cube.this.computedMeasures.get(computedMeasure)).getType(Cube.this.measures))))).withMethod("computeMeasures", Expressions.sequence(list -> {
                for (String computedMeasure : this.resultComputedMeasures) {
                    Expression record = Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass);
                    list.add(Expressions.set((StoreDef)Expressions.property((Expression)record, (String)computedMeasure), (Expression)((ComputedMeasure)Cube.this.computedMeasures.get(computedMeasure)).getExpression(record, Cube.this.measures)));
                }
            })).buildClassAndCreateNewInstance();
        }

        private Predicate<R> createHavingPredicate() {
            if (this.queryHaving == AggregationPredicates.alwaysTrue()) {
                return o -> true;
            }
            if (this.queryHaving == AggregationPredicates.alwaysFalse()) {
                return o -> false;
            }
            return (Predicate)ClassBuilder.create((DefiningClassLoader)this.queryClassLoader, Predicate.class, (Class[])new Class[0]).withClassKey(new Object[]{this.resultClass, this.queryHaving}).withMethod("test", this.queryHaving.createPredicate(Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), Cube.this.fieldTypes)).buildClassAndCreateNewInstance();
        }

        Comparator<R> createComparator() {
            if (this.query.getOrderings().isEmpty()) {
                return (o1, o2) -> 0;
            }
            return (Comparator)ClassBuilder.create((DefiningClassLoader)this.queryClassLoader, Comparator.class, (Class[])new Class[0]).withClassKey(new Object[]{this.resultClass, this.query.getOrderings()}).withMethod("compare", (Expression)io.activej.common.Utils.of(() -> {
                ExpressionComparator comparator = ExpressionComparator.create();
                for (CubeQuery.Ordering ordering : this.query.getOrderings()) {
                    String field = ordering.getField();
                    if (!this.resultMeasures.contains(field) && !this.resultAttributes.contains(field)) continue;
                    String property = field.replace('.', '$');
                    comparator.with(ordering.isAsc() ? ExpressionComparator.leftProperty(this.resultClass, (String)property) : ExpressionComparator.rightProperty(this.resultClass, (String)property), ordering.isAsc() ? ExpressionComparator.rightProperty(this.resultClass, (String)property) : ExpressionComparator.leftProperty(this.resultClass, (String)property), true);
                    this.resultOrderings.add(field);
                }
                return comparator;
            })).buildClassAndCreateNewInstance();
        }

        Promise<QueryResult> processResults(List<R> results) {
            R totals;
            try {
                totals = this.resultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (results.isEmpty()) {
                this.totalsFunction.zero(totals);
            } else {
                Iterator<R> iterator = results.iterator();
                R first = iterator.next();
                this.measuresFunction.computeMeasures(first);
                this.totalsFunction.init(totals, first);
                while (iterator.hasNext()) {
                    R next = iterator.next();
                    this.measuresFunction.computeMeasures(next);
                    this.totalsFunction.accumulate(totals, next);
                }
                this.totalsFunction.computeMeasures(totals);
            }
            Record totalRecord = this.recordScheme.record();
            this.recordFunction.copyMeasures(totals, totalRecord);
            ArrayList<Promise<Void>> tasks = new ArrayList<Promise<Void>>();
            LinkedHashMap<String, Object> filterAttributes = new LinkedHashMap<String, Object>();
            for (AttributeResolverContainer resolverContainer : Cube.this.attributeResolvers) {
                ArrayList<String> attributes = new ArrayList<String>(resolverContainer.attributes);
                attributes.retainAll(this.resultAttributes);
                if (attributes.isEmpty()) continue;
                tasks.add(Utils.resolveAttributes(results, resolverContainer.resolver, resolverContainer.dimensions, attributes, this.fullySpecifiedDimensions, this.resultClass, this.queryClassLoader));
            }
            for (AttributeResolverContainer resolverContainer : Cube.this.attributeResolvers) {
                if (!this.fullySpecifiedDimensions.keySet().containsAll(resolverContainer.dimensions)) continue;
                tasks.add(this.resolveSpecifiedDimensions(resolverContainer, filterAttributes));
            }
            return Promises.all(tasks).map($ -> this.processResults2(results, totals, filterAttributes));
        }

        QueryResult processResults2(List<R> results, R totals, Map<String, Object> filterAttributes) {
            results = results.stream().filter(this.havingPredicate).collect(Collectors.toList());
            int totalCount = results.size();
            results = this.applyLimitAndOffset(results);
            ArrayList<Record> resultRecords = new ArrayList<Record>(results.size());
            for (Object result : results) {
                Record record = this.recordScheme.record();
                this.recordFunction.copyAttributes(result, record);
                this.recordFunction.copyMeasures(result, record);
                resultRecords.add(record);
            }
            if (this.query.getReportType() == ReportType.DATA) {
                return QueryResult.createForData(this.recordScheme, resultRecords, this.recordAttributes, this.recordMeasures, this.resultOrderings, filterAttributes);
            }
            if (this.query.getReportType() == ReportType.DATA_WITH_TOTALS) {
                Record totalRecord = this.recordScheme.record();
                this.recordFunction.copyMeasures(totals, totalRecord);
                return QueryResult.createForDataWithTotals(this.recordScheme, resultRecords, totalRecord, totalCount, this.recordAttributes, this.recordMeasures, this.resultOrderings, filterAttributes);
            }
            throw new AssertionError();
        }

        private Promise<Void> resolveSpecifiedDimensions(AttributeResolverContainer resolverContainer, Map<String, Object> result) {
            Object[] key = new Object[resolverContainer.dimensions.size()];
            for (int i = 0; i < resolverContainer.dimensions.size(); ++i) {
                String dimension = (String)resolverContainer.dimensions.get(i);
                key[i] = this.fullySpecifiedDimensions.get(dimension);
            }
            Ref attributesRef = new Ref();
            return resolverContainer.resolver.resolveAttributes(Collections.singletonList(key), result1 -> (Object[])result1, (result12, attributes) -> {
                attributesRef.value = attributes;
            }).whenResult(() -> {
                for (int i = 0; i < resolverContainer.attributes.size(); ++i) {
                    String attribute = (String)resolverContainer.attributes.get(i);
                    result.put(attribute, attributesRef.value != null ? ((Object[])attributesRef.value)[i] : null);
                }
            });
        }

        List<R> applyLimitAndOffset(List<R> results) {
            int end;
            int start;
            Integer offset = this.query.getOffset();
            Integer limit = this.query.getLimit();
            if (offset == null) {
                start = 0;
                offset = 0;
            } else {
                if (offset >= results.size()) {
                    return new ArrayList();
                }
                start = offset;
            }
            if (limit == null) {
                end = results.size();
                limit = results.size();
            } else {
                end = Math.min(start + limit, results.size());
            }
            if (this.comparator != null) {
                return results.stream().sorted(this.comparator).skip(offset.intValue()).limit(limit.intValue()).collect(Collectors.toList());
            }
            return results.subList(start, end);
        }

        TotalsFunction<R, R> createTotalsFunction() {
            return (TotalsFunction)ClassBuilder.create((DefiningClassLoader)this.queryClassLoader, TotalsFunction.class, (Class[])new Class[0]).withClassKey(new Object[]{this.resultClass, this.resultStoredMeasures, this.resultComputedMeasures}).withMethod("zero", Expressions.sequence(expressions -> {
                for (String field : this.resultStoredMeasures) {
                    Measure measure = (Measure)Cube.this.measures.get(field);
                    expressions.add(measure.zeroAccumulator(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field)));
                }
            })).withMethod("init", Expressions.sequence(expressions -> {
                for (String field : this.resultStoredMeasures) {
                    Measure measure = (Measure)Cube.this.measures.get(field);
                    expressions.add(measure.initAccumulatorWithAccumulator(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field), (Expression)Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), this.resultClass), (String)field)));
                }
            })).withMethod("accumulate", Expressions.sequence(expressions -> {
                for (String field : this.resultStoredMeasures) {
                    Measure measure = (Measure)Cube.this.measures.get(field);
                    expressions.add(measure.reduce(Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass), (String)field), Expressions.property((Expression)Expressions.cast((Expression)Expressions.arg((int)1), this.resultClass), (String)field)));
                }
            })).withMethod("computeMeasures", Expressions.sequence(expressions -> {
                for (String computedMeasure : this.resultComputedMeasures) {
                    Expression result = Expressions.cast((Expression)Expressions.arg((int)0), this.resultClass);
                    expressions.add(Expressions.set((StoreDef)Expressions.property((Expression)result, (String)computedMeasure), (Expression)((ComputedMeasure)Cube.this.computedMeasures.get(computedMeasure)).getExpression(result, Cube.this.measures)));
                }
            })).buildClassAndCreateNewInstance();
        }
    }
}

