/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube;

import io.activej.aggregation.AggregationPredicate;
import io.activej.aggregation.AggregationPredicates;
import io.activej.common.api.WithInitializer;
import io.activej.cube.ReportType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class CubeQuery
implements WithInitializer<CubeQuery> {
    private Set<String> attributes = new LinkedHashSet<String>();
    private Set<String> measures = new LinkedHashSet<String>();
    private AggregationPredicate where = AggregationPredicates.alwaysTrue();
    private AggregationPredicate having = AggregationPredicates.alwaysTrue();
    private Integer limit = null;
    private Integer offset = null;
    private List<Ordering> orderings = new ArrayList<Ordering>();
    private ReportType reportType = ReportType.DATA_WITH_TOTALS;

    private CubeQuery() {
    }

    public static CubeQuery create() {
        return new CubeQuery();
    }

    public CubeQuery withMeasures(List<String> measures) {
        this.measures = new LinkedHashSet<String>(measures);
        return this;
    }

    public CubeQuery withMeasures(String ... measures) {
        return this.withMeasures(Arrays.asList(measures));
    }

    public CubeQuery withAttributes(List<String> attributes) {
        this.attributes = new LinkedHashSet<String>(attributes);
        return this;
    }

    public CubeQuery withAttributes(String ... attributes) {
        return this.withAttributes(Arrays.asList(attributes));
    }

    public CubeQuery withWhere(AggregationPredicate where) {
        this.where = where;
        return this;
    }

    public CubeQuery withHaving(AggregationPredicate having) {
        this.having = having;
        return this;
    }

    public CubeQuery withOrderings(List<Ordering> orderings) {
        this.orderings = orderings;
        return this;
    }

    public CubeQuery withOrderingAsc(String field) {
        this.orderings.add(Ordering.asc(field));
        return this;
    }

    public CubeQuery withOrderingDesc(String field) {
        this.orderings.add(Ordering.desc(field));
        return this;
    }

    public CubeQuery withOrderings(Ordering ... orderings) {
        return this.withOrderings(Arrays.asList(orderings));
    }

    public CubeQuery withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public CubeQuery withOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public CubeQuery withReportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getMeasures() {
        return this.measures;
    }

    public AggregationPredicate getWhere() {
        return this.where;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public AggregationPredicate getHaving() {
        return this.having;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String toString() {
        return "CubeQuery{attributes=" + this.attributes + ", measures=" + this.measures + ", where=" + this.where + ", having=" + this.having + ", limit=" + this.limit + ", offset=" + this.offset + ", orderings=" + this.orderings + ", reportType=" + (Object)((Object)this.reportType) + '}';
    }

    public static final class Ordering {
        private final String field;
        private final boolean desc;

        private Ordering(String field, boolean desc) {
            this.field = field;
            this.desc = desc;
        }

        public static Ordering asc(String field) {
            return new Ordering(field, false);
        }

        public static Ordering desc(String field) {
            return new Ordering(field, true);
        }

        public String getField() {
            return this.field;
        }

        public boolean isAsc() {
            return !this.isDesc();
        }

        public boolean isDesc() {
            return this.desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ordering that = (Ordering)o;
            return this.desc == that.desc && this.field.equals(that.field);
        }

        public int hashCode() {
            int result = this.field.hashCode();
            result = 31 * result + (this.desc ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.field + " " + (this.desc ? "desc" : "asc");
        }
    }
}

