/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.attributes;

import io.activej.cube.attributes.AttributeResolver;
import io.activej.promise.Promise;
import java.util.List;

public abstract class AbstractAttributeResolver<K, A>
implements AttributeResolver {
    protected abstract K toKey(Object[] var1);

    protected abstract Object[] toAttributes(A var1);

    protected abstract A resolveAttributes(K var1);

    protected Promise<Void> prepareToResolveAttributes(List<Object> results, AttributeResolver.KeyFunction keyFunction, AttributeResolver.AttributesFunction attributesFunction) {
        return Promise.complete();
    }

    private Promise<Void> doResolveAttributes(List<Object> results, AttributeResolver.KeyFunction keyFunction, AttributeResolver.AttributesFunction attributesFunction) {
        for (Object result : results) {
            K key = this.toKey(keyFunction.extractKey(result));
            A attributes = this.resolveAttributes(key);
            if (attributes == null) continue;
            attributesFunction.applyAttributes(result, this.toAttributes(attributes));
        }
        return Promise.complete();
    }

    @Override
    public final Promise<Void> resolveAttributes(List<Object> results, AttributeResolver.KeyFunction keyFunction, AttributeResolver.AttributesFunction attributesFunction) {
        return this.prepareToResolveAttributes(results, keyFunction, attributesFunction).then(() -> this.doResolveAttributes(results, keyFunction, attributesFunction));
    }
}

