/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.http;

import io.activej.aggregation.AggregationPredicate;
import io.activej.async.util.LogUtils;
import io.activej.codec.StructuredCodec;
import io.activej.codec.json.JsonUtils;
import io.activej.codec.registry.CodecFactory;
import io.activej.codegen.DefiningClassLoader;
import io.activej.common.exception.parse.ParseException;
import io.activej.cube.CubeQuery;
import io.activej.cube.ICube;
import io.activej.cube.QueryResult;
import io.activej.cube.http.AggregationPredicateCodec;
import io.activej.cube.http.QueryResultCodec;
import io.activej.cube.http.Utils;
import io.activej.http.AsyncHttpClient;
import io.activej.http.HttpException;
import io.activej.http.HttpRequest;
import io.activej.http.HttpUtils;
import io.activej.http.IAsyncHttpClient;
import io.activej.promise.Promise;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CubeHttpClient
implements ICube {
    private static final Logger logger = LoggerFactory.getLogger(CubeHttpClient.class);
    private final String url;
    private final IAsyncHttpClient httpClient;
    private final CodecFactory mapping;
    private StructuredCodec<QueryResult> queryResultCodec;
    private StructuredCodec<AggregationPredicate> aggregationPredicateCodec;
    private final Map<String, Type> attributeTypes = new LinkedHashMap<String, Type>();
    private final Map<String, Type> measureTypes = new LinkedHashMap<String, Type>();
    private DefiningClassLoader classLoader = DefiningClassLoader.create();

    private CubeHttpClient(IAsyncHttpClient httpClient, String url, CodecFactory mapping) {
        this.url = url.replaceAll("/$", "");
        this.httpClient = httpClient;
        this.mapping = mapping;
    }

    public static CubeHttpClient create(AsyncHttpClient httpClient, String cubeServletUrl) {
        return new CubeHttpClient((IAsyncHttpClient)httpClient, cubeServletUrl, Utils.CUBE_TYPES);
    }

    public static CubeHttpClient create(AsyncHttpClient httpClient, URI cubeServletUrl) {
        return CubeHttpClient.create(httpClient, cubeServletUrl.toString());
    }

    public CubeHttpClient withClassLoader(DefiningClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public CubeHttpClient withAttribute(String attribute, Type type) {
        this.attributeTypes.put(attribute, type);
        return this;
    }

    public CubeHttpClient withMeasure(String measureId, Class<?> type) {
        this.measureTypes.put(measureId, type);
        return this;
    }

    private StructuredCodec<AggregationPredicate> getAggregationPredicateCodec() {
        if (this.aggregationPredicateCodec == null) {
            this.aggregationPredicateCodec = AggregationPredicateCodec.create(this.mapping, this.attributeTypes, this.measureTypes);
        }
        return this.aggregationPredicateCodec;
    }

    private StructuredCodec<QueryResult> getQueryResultCodec() {
        if (this.queryResultCodec == null) {
            this.queryResultCodec = QueryResultCodec.create(this.classLoader, this.mapping, this.attributeTypes, this.measureTypes);
        }
        return this.queryResultCodec;
    }

    @Override
    public Map<String, Type> getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public Map<String, Type> getMeasureTypes() {
        return this.measureTypes;
    }

    @Override
    public Promise<QueryResult> query(CubeQuery query) {
        return this.httpClient.request(this.buildRequest(query)).then(response -> response.loadBody().then(body -> {
            try {
                String httpResponse = body.getString(StandardCharsets.UTF_8);
                if (response.getCode() != 200) {
                    return Promise.ofException((Throwable)HttpException.ofCode((int)400, (String)("Cube HTTP query failed. Response code: " + response.getCode() + " Body: " + httpResponse)));
                }
                QueryResult result = (QueryResult)JsonUtils.fromJson(this.getQueryResultCodec(), (String)httpResponse);
                return Promise.of((Object)result);
            }
            catch (ParseException e) {
                return Promise.ofException((Throwable)HttpException.ofCode((int)400, (String)"Cube HTTP query failed. Invalid data received", (Throwable)e));
            }
        }).whenComplete(LogUtils.toLogger((Logger)logger, (String)"query", (Object[])new Object[]{query})));
    }

    private HttpRequest buildRequest(CubeQuery query) {
        LinkedHashMap<String, String> urlParams = new LinkedHashMap<String, String>();
        urlParams.put("attributes", String.join((CharSequence)",", query.getAttributes()));
        urlParams.put("measures", String.join((CharSequence)",", query.getMeasures()));
        urlParams.put("where", JsonUtils.toJson(this.getAggregationPredicateCodec(), (Object)query.getWhere()));
        urlParams.put("sort", Utils.formatOrderings(query.getOrderings()));
        urlParams.put("having", JsonUtils.toJson(this.getAggregationPredicateCodec(), (Object)query.getHaving()));
        if (query.getLimit() != null) {
            urlParams.put("limit", query.getLimit().toString());
        }
        if (query.getOffset() != null) {
            urlParams.put("offset", query.getOffset().toString());
        }
        urlParams.put("reportType", query.getReportType().toString().toLowerCase());
        String url = this.url + "/?" + HttpUtils.renderQueryString(urlParams);
        return HttpRequest.get((String)url);
    }
}

