/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.http;

import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredEncoder;
import io.activej.codec.StructuredInput;
import io.activej.codec.StructuredOutput;
import io.activej.codec.registry.CodecFactory;
import io.activej.codegen.DefiningClassLoader;
import io.activej.common.Utils;
import io.activej.common.exception.parse.ParseException;
import io.activej.common.reflection.RecursiveType;
import io.activej.cube.QueryResult;
import io.activej.cube.ReportType;
import io.activej.record.Record;
import io.activej.record.RecordScheme;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class QueryResultCodec
implements StructuredCodec<QueryResult> {
    private static final String MEASURES_FIELD = "measures";
    private static final String ATTRIBUTES_FIELD = "attributes";
    private static final String FILTER_ATTRIBUTES_FIELD = "filterAttributes";
    private static final String RECORDS_FIELD = "records";
    private static final String TOTALS_FIELD = "totals";
    private static final String COUNT_FIELD = "count";
    private static final String SORTED_BY_FIELD = "sortedBy";
    private static final String METADATA_FIELD = "metadata";
    private final Map<String, StructuredCodec<?>> attributeCodecs;
    private final Map<String, StructuredCodec<?>> measureCodecs;
    private final Map<String, Class<?>> attributeTypes;
    private final Map<String, Class<?>> measureTypes;
    private static final StructuredCodec<List<String>> STRING_CODEC = StructuredCodecs.STRING_CODEC.ofList();
    private final DefiningClassLoader classLoader;

    public QueryResultCodec(DefiningClassLoader classLoader, Map<String, StructuredCodec<?>> attributeCodecs, Map<String, StructuredCodec<?>> measureCodecs, Map<String, Class<?>> attributeTypes, Map<String, Class<?>> measureTypes) {
        this.classLoader = classLoader;
        this.attributeCodecs = attributeCodecs;
        this.measureCodecs = measureCodecs;
        this.attributeTypes = attributeTypes;
        this.measureTypes = measureTypes;
    }

    public static QueryResultCodec create(DefiningClassLoader classLoader, CodecFactory mapping, Map<String, Type> attributeTypes, Map<String, Type> measureTypes) {
        RecursiveType token;
        LinkedHashMap attributeCodecs = new LinkedHashMap();
        LinkedHashMap measureCodecs = new LinkedHashMap();
        LinkedHashMap attributeRawTypes = new LinkedHashMap();
        LinkedHashMap measureRawTypes = new LinkedHashMap();
        for (Map.Entry<String, Type> entry : attributeTypes.entrySet()) {
            token = RecursiveType.of((Type)entry.getValue());
            attributeCodecs.put(entry.getKey(), mapping.get(token.getType()).nullable());
            attributeRawTypes.put(entry.getKey(), token.getRawType());
        }
        for (Map.Entry<String, Type> entry : measureTypes.entrySet()) {
            token = RecursiveType.of((Type)entry.getValue());
            measureCodecs.put(entry.getKey(), mapping.get(token.getType()));
            measureRawTypes.put(entry.getKey(), token.getRawType());
        }
        return new QueryResultCodec(classLoader, attributeCodecs, measureCodecs, attributeRawTypes, measureRawTypes);
    }

    public QueryResult decode(StructuredInput reader) throws ParseException {
        return (QueryResult)reader.readObject($1 -> {
            RecordScheme recordScheme = null;
            ArrayList<String> attributes = new ArrayList<String>();
            ArrayList<String> measures = new ArrayList<String>();
            List sortedBy = null;
            List<Record> records = null;
            Record totals = null;
            int totalCount = 0;
            Map<String, Object> filterAttributes = null;
            block16: while (reader.hasNext()) {
                String field;
                switch (field = reader.readKey()) {
                    case "metadata": {
                        reader.readObject(() -> {
                            reader.readKey(ATTRIBUTES_FIELD);
                            attributes.addAll((Collection)STRING_CODEC.decode(reader));
                            reader.readKey(MEASURES_FIELD);
                            measures.addAll((Collection)STRING_CODEC.decode(reader));
                        });
                        recordScheme = this.recordScheme(attributes, measures);
                        continue block16;
                    }
                    case "sortedBy": {
                        sortedBy = (List)STRING_CODEC.decode(reader);
                        continue block16;
                    }
                    case "records": {
                        records = this.readRecords(reader, recordScheme);
                        continue block16;
                    }
                    case "count": {
                        totalCount = reader.readInt();
                        continue block16;
                    }
                    case "filterAttributes": {
                        filterAttributes = this.readFilterAttributes(reader);
                        continue block16;
                    }
                    case "totals": {
                        totals = this.readTotals(reader, recordScheme);
                        continue block16;
                    }
                }
                throw new ParseException("Unknown field: " + field);
            }
            return QueryResult.create(recordScheme, attributes, measures, Utils.nullToEmpty(sortedBy), Utils.nullToEmpty(records), (Record)Utils.nullToDefault(totals, (Object)recordScheme.record()), totalCount, Utils.nullToEmpty(filterAttributes), totals != null ? ReportType.DATA_WITH_TOTALS : (records != null ? ReportType.DATA : ReportType.METADATA));
        });
    }

    private List<Record> readRecords(StructuredInput reader, RecordScheme recordScheme) throws ParseException {
        StructuredCodec<?>[] fieldStructuredCodecs = this.getStructuredCodecs(recordScheme);
        StructuredDecoder recordDecoder = in -> {
            Record record = recordScheme.record();
            for (int i = 0; i < fieldStructuredCodecs.length; ++i) {
                Object fieldValue = fieldStructuredCodecs[i].decode(in);
                record.set(i, fieldValue);
            }
            return record;
        };
        return (List)reader.readTuple($1 -> {
            ArrayList<Record> records = new ArrayList<Record>();
            while (reader.hasNext()) {
                records.add((Record)reader.readTuple(recordDecoder));
            }
            return records;
        });
    }

    private Record readTotals(StructuredInput reader, RecordScheme recordScheme) throws ParseException {
        return (Record)reader.readTuple($ -> {
            Record totals = recordScheme.record();
            for (int i = 0; i < recordScheme.getFields().size(); ++i) {
                String field = recordScheme.getField(i);
                StructuredCodec<?> fieldStructuredCodec = this.measureCodecs.get(field);
                if (fieldStructuredCodec == null) continue;
                Object fieldValue = fieldStructuredCodec.decode(reader);
                totals.set(i, fieldValue);
            }
            return totals;
        });
    }

    private Map<String, Object> readFilterAttributes(StructuredInput reader) throws ParseException {
        return (Map)reader.readObject($ -> {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            while (reader.hasNext()) {
                String attribute = reader.readKey();
                Object value = this.attributeCodecs.get(attribute).decode(reader);
                result.put(attribute, value);
            }
            return result;
        });
    }

    public void encode(StructuredOutput writer, QueryResult result) {
        writer.writeObject(() -> {
            writer.writeKey(METADATA_FIELD);
            writer.writeObject(() -> {
                writer.writeKey(ATTRIBUTES_FIELD);
                STRING_CODEC.encode(writer, result.getAttributes());
                writer.writeKey(MEASURES_FIELD);
                STRING_CODEC.encode(writer, result.getMeasures());
            });
            if (result.getReportType() == ReportType.DATA || result.getReportType() == ReportType.DATA_WITH_TOTALS) {
                writer.writeKey(SORTED_BY_FIELD);
                STRING_CODEC.encode(writer, result.getSortedBy());
            }
            if (result.getReportType() == ReportType.DATA || result.getReportType() == ReportType.DATA_WITH_TOTALS) {
                writer.writeKey(RECORDS_FIELD);
                this.writeRecords(writer, result.getRecordScheme(), result.getRecords());
                writer.writeKey(COUNT_FIELD);
                writer.writeInt(result.getTotalCount());
                writer.writeKey(FILTER_ATTRIBUTES_FIELD);
                this.writeFilterAttributes(writer, result.getFilterAttributes());
            }
            if (result.getReportType() == ReportType.DATA_WITH_TOTALS) {
                writer.writeKey(TOTALS_FIELD);
                this.writeTotals(writer, result.getRecordScheme(), result.getTotals());
            }
        });
    }

    private void writeRecords(StructuredOutput writer, RecordScheme recordScheme, List<Record> records) {
        StructuredCodec<?>[] fieldStructuredCodecs = this.getStructuredCodecs(recordScheme);
        StructuredEncoder recordEncoder = (out, record) -> {
            for (int i = 0; i < recordScheme.getFields().size(); ++i) {
                fieldStructuredCodecs[i].encode(writer, record.get(i));
            }
        };
        writer.writeTuple(() -> {
            for (Record record : records) {
                writer.writeTuple(recordEncoder, (Object)record);
            }
        });
    }

    private void writeTotals(StructuredOutput writer, RecordScheme recordScheme, Record totals) {
        writer.writeTuple(() -> {
            for (int i = 0; i < recordScheme.getFields().size(); ++i) {
                String field = recordScheme.getField(i);
                StructuredCodec<?> fieldStructuredCodec = this.measureCodecs.get(field);
                if (fieldStructuredCodec == null) continue;
                fieldStructuredCodec.encode(writer, totals.get(i));
            }
        });
    }

    private void writeFilterAttributes(StructuredOutput writer, Map<String, Object> filterAttributes) {
        writer.writeObject(() -> {
            for (Map.Entry entry : filterAttributes.entrySet()) {
                writer.writeKey((String)entry.getKey());
                StructuredCodec<?> codec = this.attributeCodecs.get(entry.getKey());
                codec.encode(writer, entry.getValue());
            }
        });
    }

    public RecordScheme recordScheme(List<String> attributes, List<String> measures) {
        RecordScheme recordScheme = RecordScheme.create((DefiningClassLoader)this.classLoader);
        for (String attribute : attributes) {
            recordScheme.withField(attribute, (Type)this.attributeTypes.get(attribute));
        }
        for (String measure : measures) {
            recordScheme.withField(measure, (Type)this.measureTypes.get(measure));
        }
        recordScheme.build();
        return recordScheme;
    }

    private StructuredCodec<?>[] getStructuredCodecs(RecordScheme recordScheme) {
        StructuredCodec[] fieldStructuredCodecs = new StructuredCodec[recordScheme.getFields().size()];
        for (int i = 0; i < recordScheme.getFields().size(); ++i) {
            String field = recordScheme.getField(i);
            fieldStructuredCodecs[i] = (StructuredCodec)Utils.firstNonNull(this.attributeCodecs.get(field), this.measureCodecs.get(field));
        }
        return fieldStructuredCodecs;
    }
}

