/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.http;

import io.activej.aggregation.fieldtype.FieldTypes;
import io.activej.codec.registry.CodecFactory;
import io.activej.codec.registry.CodecRegistry;
import io.activej.common.exception.parse.ParseException;
import io.activej.cube.CubeQuery;
import io.activej.cube.ReportType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class Utils {
    public static final ParseException MALFORMED_TAIL = new ParseException(Utils.class, "Tail is neither 'asc' nor 'desc'");
    public static final ParseException MISSING_SEMICOLON = new ParseException(Utils.class, "Failed to parse orderings, missing semicolon");
    static final String MEASURES_PARAM = "measures";
    static final String ATTRIBUTES_PARAM = "attributes";
    static final String WHERE_PARAM = "where";
    static final String HAVING_PARAM = "having";
    static final String SORT_PARAM = "sort";
    static final String LIMIT_PARAM = "limit";
    static final String OFFSET_PARAM = "offset";
    static final String REPORT_TYPE_PARAM = "reportType";
    private static final Pattern splitter = Pattern.compile(",");
    public static final CodecFactory CUBE_TYPES = CodecRegistry.createDefault().with(LocalDate.class, FieldTypes.LOCAL_DATE_CODEC);

    Utils() {
    }

    static String formatOrderings(List<CubeQuery.Ordering> orderings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CubeQuery.Ordering ordering : orderings) {
            sb.append(first ? "" : ",").append(ordering.getField()).append(":").append(ordering.isAsc() ? "ASC" : "DESC");
            first = false;
        }
        return sb.toString();
    }

    static List<CubeQuery.Ordering> parseOrderings(String string) throws ParseException {
        ArrayList<CubeQuery.Ordering> result = new ArrayList<CubeQuery.Ordering>();
        List tokens = splitter.splitAsStream(string).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        for (String s2 : tokens) {
            int i = s2.indexOf(58);
            if (i == -1) {
                throw MISSING_SEMICOLON;
            }
            String field = s2.substring(0, i);
            String tail = s2.substring(i + 1).toLowerCase();
            if ("asc".equals(tail)) {
                result.add(CubeQuery.Ordering.asc(field));
                continue;
            }
            if ("desc".equals(tail)) {
                result.add(CubeQuery.Ordering.desc(field));
                continue;
            }
            throw MALFORMED_TAIL;
        }
        return result;
    }

    static int parseNonNegativeInteger(String parameter) throws ParseException {
        try {
            int value = Integer.parseInt(parameter);
            if (value < 0) {
                throw new ParseException("Must be non negative value: " + parameter);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Could not parse: " + parameter, (Throwable)e);
        }
    }

    static ReportType parseReportType(String parameter) throws ParseException {
        try {
            return ReportType.valueOf(parameter.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("'" + parameter + "' neither of: " + Arrays.toString((Object[])ReportType.values()), (Throwable)e);
        }
    }
}

