/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.ot;

import io.activej.aggregation.ot.AggregationDiff;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class CubeDiff {
    private final Map<String, AggregationDiff> diffs;

    private CubeDiff(Map<String, AggregationDiff> diffs) {
        this.diffs = diffs;
    }

    public static CubeDiff of(Map<String, AggregationDiff> aggregationOps) {
        HashMap<String, AggregationDiff> map = new HashMap<String, AggregationDiff>();
        for (Map.Entry<String, AggregationDiff> entry : aggregationOps.entrySet()) {
            AggregationDiff value = entry.getValue();
            if (value.isEmpty()) continue;
            map.put(entry.getKey(), value);
        }
        return new CubeDiff(map);
    }

    public Set<String> keySet() {
        return this.diffs.keySet();
    }

    public AggregationDiff get(String id) {
        return this.diffs.get(id);
    }

    public static CubeDiff empty() {
        return new CubeDiff(Collections.emptyMap());
    }

    public CubeDiff inverse() {
        HashMap<String, AggregationDiff> map = new HashMap<String, AggregationDiff>();
        for (Map.Entry<String, AggregationDiff> entry : this.diffs.entrySet()) {
            String key = entry.getKey();
            AggregationDiff value = entry.getValue();
            map.put(key, value.inverse());
        }
        return new CubeDiff(map);
    }

    public boolean isEmpty() {
        return this.diffs.isEmpty();
    }

    public <C> Stream<C> addedChunks() {
        return this.diffs.values().stream().flatMap(aggregationDiff -> aggregationDiff.getAddedChunks().stream()).map(aggregationChunk -> aggregationChunk.getChunkId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubeDiff cubeDiff = (CubeDiff)o;
        return Objects.equals(this.diffs, cubeDiff.diffs);
    }

    public int hashCode() {
        return this.diffs != null ? this.diffs.hashCode() : 0;
    }

    public String toString() {
        return "{diffs:" + this.diffs.size() + '}';
    }
}

