/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.ot;

import io.activej.cube.ot.CubeDiff;
import io.activej.etl.LogDiff;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CubeDiffScheme<D> {
    public D wrap(CubeDiff var1);

    default public List<CubeDiff> unwrap(D diff) {
        return this.unwrapToStream(diff).collect(Collectors.toList());
    }

    default public Stream<CubeDiff> unwrapToStream(D diff) {
        return this.unwrap(diff).stream();
    }

    public static CubeDiffScheme<LogDiff<CubeDiff>> ofLogDiffs() {
        return new CubeDiffScheme<LogDiff<CubeDiff>>(){

            @Override
            public LogDiff<CubeDiff> wrap(CubeDiff cubeDiff) {
                return LogDiff.forCurrentPosition((Object)cubeDiff);
            }

            @Override
            public List<CubeDiff> unwrap(LogDiff<CubeDiff> diff) {
                return diff.getDiffs();
            }
        };
    }

    public static CubeDiffScheme<CubeDiff> ofCubeDiffs() {
        return new CubeDiffScheme<CubeDiff>(){

            @Override
            public CubeDiff wrap(CubeDiff cubeDiff) {
                return cubeDiff;
            }

            @Override
            public List<CubeDiff> unwrap(CubeDiff diff) {
                return Collections.singletonList(diff);
            }
        };
    }
}

