/*
 * Decompiled with CFR 0.152.
 */
package io.activej.cube.service;

import io.activej.aggregation.ActiveFsChunkStorage;
import io.activej.async.function.AsyncSupplier;
import io.activej.async.function.AsyncSuppliers;
import io.activej.async.util.LogUtils;
import io.activej.common.collection.CollectionUtils;
import io.activej.cube.Utils;
import io.activej.cube.ot.CubeDiffScheme;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanEx;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.ot.OTAlgorithms;
import io.activej.ot.OTCommit;
import io.activej.ot.repository.OTRepositoryEx;
import io.activej.ot.system.OTSystem;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.promise.jmx.PromiseStats;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CubeBackupController<K, D, C>
implements EventloopJmxBeanEx {
    private static final Logger logger = LoggerFactory.getLogger(CubeBackupController.class);
    public static final Duration DEFAULT_SMOOTHING_WINDOW = Duration.ofMinutes(5L);
    private final Eventloop eventloop;
    private final OTSystem<D> otSystem;
    private final OTRepositoryEx<K, D> repository;
    private final ActiveFsChunkStorage<C> storage;
    private final CubeDiffScheme<D> cubeDiffScheme;
    private final PromiseStats promiseBackup = PromiseStats.create((Duration)DEFAULT_SMOOTHING_WINDOW);
    private final PromiseStats promiseBackupDb = PromiseStats.create((Duration)DEFAULT_SMOOTHING_WINDOW);
    private final PromiseStats promiseBackupChunks = PromiseStats.create((Duration)DEFAULT_SMOOTHING_WINDOW);
    private final AsyncSupplier<Void> backup = AsyncSuppliers.reuse(this::backupHead);

    CubeBackupController(Eventloop eventloop, CubeDiffScheme<D> cubeDiffScheme, OTRepositoryEx<K, D> repository, OTSystem<D> otSystem, ActiveFsChunkStorage<C> storage) {
        this.eventloop = eventloop;
        this.cubeDiffScheme = cubeDiffScheme;
        this.otSystem = otSystem;
        this.repository = repository;
        this.storage = storage;
    }

    public static <K, D, C> CubeBackupController<K, D, C> create(Eventloop eventloop, CubeDiffScheme<D> cubeDiffScheme, OTRepositoryEx<K, D> otRepository, OTSystem<D> otSystem, ActiveFsChunkStorage<C> storage) {
        return new CubeBackupController<K, D, C>(eventloop, cubeDiffScheme, otRepository, otSystem, storage);
    }

    public Promise<Void> backup() {
        return this.backup.get();
    }

    public Promise<Void> backupHead() {
        return this.repository.getHeads().then(heads -> {
            if (heads.isEmpty()) {
                return Promise.ofException((Throwable)new IllegalArgumentException("heads is empty"));
            }
            return this.backup(CollectionUtils.first((Iterable)heads));
        }).whenComplete(this.promiseBackup.recordStats()).whenComplete(LogUtils.toLogger((Logger)logger, (String)LogUtils.thisMethod(), (Object[])new Object[0]));
    }

    public Promise<Void> backup(K commitId) {
        return Promises.toTuple((Promise)this.repository.loadCommit(commitId), (Promise)OTAlgorithms.checkout(this.repository, this.otSystem, commitId)).then(tuple -> Promises.sequence(() -> this.backupChunks(commitId, Utils.chunksInDiffs(this.cubeDiffScheme, (List)tuple.getValue2())), () -> this.backupDb((OTCommit)tuple.getValue1(), (List)tuple.getValue2()))).whenComplete(LogUtils.toLogger((Logger)logger, (String)LogUtils.thisMethod(), (Object[])new Object[]{commitId}));
    }

    private Promise<Void> backupChunks(K commitId, Set<C> chunkIds) {
        return this.storage.backup(String.valueOf(commitId), chunkIds).whenComplete(this.promiseBackupChunks.recordStats()).whenComplete(logger.isTraceEnabled() ? LogUtils.toLogger((Logger)logger, (LogUtils.Level)LogUtils.Level.TRACE, (String)LogUtils.thisMethod(), (Object[])new Object[]{chunkIds}) : LogUtils.toLogger((Logger)logger, (String)LogUtils.thisMethod(), (Object[])new Object[]{CollectionUtils.toLimitedString(chunkIds, (int)6)}));
    }

    private Promise<Void> backupDb(OTCommit<K, D> commit, List<D> snapshot) {
        return this.repository.backup(commit, snapshot).whenComplete(this.promiseBackupDb.recordStats()).whenComplete(LogUtils.toLogger((Logger)logger, (String)LogUtils.thisMethod(), (Object[])new Object[]{commit, snapshot}));
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    @JmxOperation
    public void backupNow() {
        this.backup();
    }

    @JmxAttribute
    public PromiseStats getPromiseBackup() {
        return this.promiseBackup;
    }

    @JmxAttribute
    public PromiseStats getPromiseBackupDb() {
        return this.promiseBackupDb;
    }

    @JmxAttribute
    public PromiseStats getPromiseBackupChunks() {
        return this.promiseBackupChunks;
    }
}

