/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.dataset.LocallySortedDataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class DatasetLocalSort<K, T>
extends LocallySortedDataset<K, T> {
    private final Dataset<T> input;
    private final int sortBufferSize;

    public DatasetLocalSort(Dataset<T> input, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator, int sortBufferSize) {
        super(input.valueType(), keyComparator, keyType, keyFunction);
        this.sortBufferSize = sortBufferSize;
        this.input = input;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(context);
        int index = context.generateNodeIndex();
        for (StreamId streamId : streamIds) {
            NodeSort node = new NodeSort(index, this.input.valueType(), this.keyFunction(), this.keyComparator(), false, this.sortBufferSize, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

