/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.inject;

import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.codec.StructuredDecoder;
import io.activej.codec.StructuredEncoder;
import io.activej.common.exception.parse.ParseException;
import io.activej.dataflow.command.DataflowCommand;
import io.activej.dataflow.command.DataflowCommandDownload;
import io.activej.dataflow.command.DataflowCommandExecute;
import io.activej.dataflow.command.DataflowCommandGetTasks;
import io.activej.dataflow.command.DataflowResponse;
import io.activej.dataflow.command.DataflowResponsePartitionData;
import io.activej.dataflow.command.DataflowResponseResult;
import io.activej.dataflow.command.DataflowResponseTaskData;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.TaskStatus;
import io.activej.dataflow.http.LocalTaskData;
import io.activej.dataflow.http.ReducedTaskData;
import io.activej.dataflow.inject.CodecsModule;
import io.activej.dataflow.node.AbstractNode;
import io.activej.dataflow.node.Node;
import io.activej.dataflow.node.NodeConsumerOfId;
import io.activej.dataflow.node.NodeDownload;
import io.activej.dataflow.node.NodeFilter;
import io.activej.dataflow.node.NodeJoin;
import io.activej.dataflow.node.NodeMap;
import io.activej.dataflow.node.NodeMerge;
import io.activej.dataflow.node.NodeReduce;
import io.activej.dataflow.node.NodeReduceSimple;
import io.activej.dataflow.node.NodeShard;
import io.activej.dataflow.node.NodeSort;
import io.activej.dataflow.node.NodeSupplierOfId;
import io.activej.dataflow.node.NodeUnion;
import io.activej.dataflow.node.NodeUpload;
import io.activej.dataflow.stats.BinaryNodeStat;
import io.activej.dataflow.stats.NodeStat;
import io.activej.dataflow.stats.TestNodeStat;
import io.activej.datastream.processor.StreamJoin;
import io.activej.datastream.processor.StreamReducers;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.inject.util.Types;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public final class DataflowCodecs
extends AbstractModule {
    private static final Comparator<?> NATURAL_ORDER = Comparator.naturalOrder();
    private static final Class<?> NATURAL_ORDER_CLASS = NATURAL_ORDER.getClass();

    private DataflowCodecs() {
    }

    public static Module create() {
        return new DataflowCodecs();
    }

    protected void configure() {
        this.install(CodecsModule.create());
        this.bind(CodecsModule.codec(DataflowCommand.class).qualified(CodecsModule.Subtypes.class));
        this.bind(CodecsModule.codec(DataflowResponse.class).qualified(CodecsModule.Subtypes.class));
        this.bind(Key.ofType((Type)Types.parameterized(StructuredCodec.class, (Type[])new Type[]{NATURAL_ORDER_CLASS}))).toInstance((Object)StructuredCodec.ofObject(() -> NATURAL_ORDER));
    }

    @Provides
    StructuredCodec<StreamId> streamId() {
        return StructuredCodec.of(in -> new StreamId(in.readLong()), (out, item) -> out.writeLong(item.getId()));
    }

    @Provides
    StructuredCodec<InetSocketAddress> address() {
        return StructuredCodec.of(in -> {
            String str = in.readString();
            String[] split = str.split(":");
            if (split.length != 2) {
                throw new ParseException("Address should be split with a single ':'");
            }
            try {
                return new InetSocketAddress(InetAddress.getByName(split[0]), Integer.parseInt(split[1]));
            }
            catch (UnknownHostException e) {
                throw new ParseException(DataflowCodecs.class, "Failed to create InetSocketAddress", (Throwable)e);
            }
        }, (out, addr) -> out.writeString(addr.getAddress().getHostAddress() + ':' + addr.getPort()));
    }

    @Provides
    StructuredCodec<DataflowCommandDownload> dataflowCommandDownload(StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(DataflowCommandDownload::new, (String)"streamId", DataflowCommandDownload::getStreamId, streamId);
    }

    @Provides
    StructuredCodec<DataflowCommandExecute> dataflowCommandExecute(@CodecsModule.Subtypes StructuredCodec<Node> node, StructuredCodec<Long> longCodec) {
        return StructuredCodecs.object(DataflowCommandExecute::new, (String)"taskId", DataflowCommandExecute::getTaskId, longCodec, (String)"nodeStats", DataflowCommandExecute::getNodes, (StructuredCodec)StructuredCodecs.ofList(node));
    }

    @Provides
    StructuredCodec<DataflowCommandGetTasks> dataflowCommandGetTasks(StructuredCodec<Long> longCodec) {
        return StructuredCodecs.object(DataflowCommandGetTasks::new, (String)"taskId", DataflowCommandGetTasks::getTaskId, (StructuredCodec)longCodec.nullable());
    }

    @Provides
    StructuredCodec<DataflowResponseResult> datagraphResponse(StructuredCodec<String> string) {
        return StructuredCodecs.object(DataflowResponseResult::new, (String)"error", DataflowResponseResult::getError, (StructuredCodec)string.nullable());
    }

    @Provides
    StructuredCodec<NodeReduce.Input> nodeReduceInput(@CodecsModule.Subtypes StructuredCodec<StreamReducers.Reducer> reducer, @CodecsModule.Subtypes StructuredCodec<Function> function) {
        return StructuredCodecs.object(NodeReduce.Input::new, (String)"reducer", NodeReduce.Input::getReducer, reducer, (String)"keyFunction", NodeReduce.Input::getKeyFunction, function);
    }

    @Provides
    StructuredCodec<StreamReducers.ReducerToResult.InputToAccumulator> inputToAccumulator(@CodecsModule.Subtypes StructuredCodec<StreamReducers.ReducerToResult> reducerToResult) {
        return StructuredCodecs.object(StreamReducers.ReducerToResult.InputToAccumulator::new, (String)"reducerToResult", StreamReducers.ReducerToResult.InputToAccumulator::getReducerToResult, reducerToResult);
    }

    @Provides
    StructuredCodec<StreamReducers.ReducerToResult.InputToOutput> inputToOutput(@CodecsModule.Subtypes StructuredCodec<StreamReducers.ReducerToResult> reducerToResult) {
        return StructuredCodecs.object(StreamReducers.ReducerToResult.InputToOutput::new, (String)"reducerToResult", StreamReducers.ReducerToResult.InputToOutput::getReducerToResult, reducerToResult);
    }

    @Provides
    StructuredCodec<StreamReducers.ReducerToResult.AccumulatorToAccumulator> accumulatorToAccumulator(@CodecsModule.Subtypes StructuredCodec<StreamReducers.ReducerToResult> reducerToResult) {
        return StructuredCodecs.object(StreamReducers.ReducerToResult.AccumulatorToAccumulator::new, (String)"reducerToResult", StreamReducers.ReducerToResult.AccumulatorToAccumulator::getReducerToResult, reducerToResult);
    }

    @Provides
    StructuredCodec<StreamReducers.ReducerToResult.AccumulatorToOutput> accumulatorToOutput(@CodecsModule.Subtypes StructuredCodec<StreamReducers.ReducerToResult> reducerToResult) {
        return StructuredCodecs.object(StreamReducers.ReducerToResult.AccumulatorToOutput::new, (String)"reducerToResult", StreamReducers.ReducerToResult.AccumulatorToOutput::getReducerToResult, reducerToResult);
    }

    @Provides
    StructuredCodec<StreamReducers.MergeDistinctReducer> mergeDistinctReducer() {
        return StructuredCodec.ofObject(StreamReducers.MergeDistinctReducer::new);
    }

    @Provides
    StructuredCodec<StreamReducers.MergeSortReducer> mergeSortReducer() {
        return StructuredCodec.ofObject(StreamReducers.MergeSortReducer::new);
    }

    @Provides
    StructuredCodec<NodeDownload> nodeDownload(StructuredCodec<Class<?>> cls, StructuredCodec<Integer> integer, StructuredCodec<InetSocketAddress> address, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeDownload::new, (String)"index", AbstractNode::getIndex, integer, (String)"type", NodeDownload::getType, cls, (String)"address", NodeDownload::getAddress, address, (String)"streamId", NodeDownload::getStreamId, streamId, (String)"output", NodeDownload::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeUpload> nodeUpload(StructuredCodec<Class<?>> cls, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeUpload::new, (String)"index", AbstractNode::getIndex, integer, (String)"type", NodeUpload::getType, cls, (String)"streamId", NodeUpload::getStreamId, streamId);
    }

    @Provides
    StructuredCodec<NodeMap> nodeMap(@CodecsModule.Subtypes StructuredCodec<Function> function, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeMap::new, (String)"index", AbstractNode::getIndex, integer, (String)"function", NodeMap::getFunction, function, (String)"input", NodeMap::getInput, streamId, (String)"output", NodeMap::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeFilter> nodeFilter(@CodecsModule.Subtypes StructuredCodec<Predicate> predicate, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeFilter::new, (String)"index", AbstractNode::getIndex, integer, (String)"predicate", NodeFilter::getPredicate, predicate, (String)"input", NodeFilter::getInput, streamId, (String)"output", NodeFilter::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeShard> nodeShard(@CodecsModule.Subtypes StructuredCodec<Function> function, StructuredCodec<StreamId> streamId, StructuredCodec<List<StreamId>> streamIds, StructuredCodec<Integer> integer) {
        return StructuredCodecs.object(NodeShard::new, (String)"index", AbstractNode::getIndex, integer, (String)"keyFunction", NodeShard::getKeyFunction, function, (String)"input", NodeShard::getInput, streamId, (String)"outputs", NodeShard::getOutputs, streamIds, (String)"nonce", NodeShard::getNonce, integer);
    }

    @Provides
    StructuredCodec<NodeMerge> nodeMerge(@CodecsModule.Subtypes StructuredCodec<Function> function, @CodecsModule.Subtypes StructuredCodec<Comparator> comparator, StructuredCodec<Integer> integer, StructuredCodec<Boolean> bool, StructuredCodec<StreamId> streamId, StructuredCodec<List<StreamId>> streamIds) {
        return StructuredCodecs.object(NodeMerge::new, (String)"index", AbstractNode::getIndex, integer, (String)"keyFunction", NodeMerge::getKeyFunction, function, (String)"keyComparator", NodeMerge::getKeyComparator, comparator, (String)"deduplicate", NodeMerge::isDeduplicate, bool, (String)"inputs", NodeMerge::getInputs, streamIds, (String)"output", NodeMerge::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeReduce> nodeReduce(@CodecsModule.Subtypes StructuredCodec<Comparator> comparator, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId, StructuredCodec<Map<StreamId, NodeReduce.Input>> inputs) {
        return StructuredCodecs.object((a, b, c, d) -> new NodeReduce((int)a, b, c, (StreamId)d), (String)"index", AbstractNode::getIndex, integer, (String)"keyComparator", NodeReduce::getKeyComparator, comparator, (String)"inputs", n -> n.getInputMap(), inputs, (String)"output", NodeReduce::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeReduceSimple> nodeReduceSimple(@CodecsModule.Subtypes StructuredCodec<Function> function, @CodecsModule.Subtypes StructuredCodec<Comparator> comparator, @CodecsModule.Subtypes StructuredCodec<StreamReducers.Reducer> reducer, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId, StructuredCodec<List<StreamId>> streamIds) {
        return StructuredCodecs.object(NodeReduceSimple::new, (String)"index", AbstractNode::getIndex, integer, (String)"keyFunction", NodeReduceSimple::getKeyFunction, function, (String)"keyComparator", NodeReduceSimple::getKeyComparator, comparator, (String)"reducer", NodeReduceSimple::getReducer, reducer, (String)"inputs", NodeReduceSimple::getInputs, streamIds, (String)"output", NodeReduceSimple::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeUnion> nodeUnion(StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId, StructuredCodec<List<StreamId>> streamIds) {
        return StructuredCodecs.object(NodeUnion::new, (String)"index", AbstractNode::getIndex, integer, (String)"inputs", NodeUnion::getInputs, streamIds, (String)"output", NodeUnion::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeSupplierOfId> nodeSupplierOfId(StructuredCodec<String> string, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeSupplierOfId::new, (String)"index", AbstractNode::getIndex, integer, (String)"id", NodeSupplierOfId::getId, string, (String)"partitionIndex", NodeSupplierOfId::getPartitionIndex, integer, (String)"maxPartitions", NodeSupplierOfId::getMaxPartitions, integer, (String)"output", NodeSupplierOfId::getOutput, streamId);
    }

    @Provides
    StructuredCodec<NodeConsumerOfId> nodeConsumerToList(StructuredCodec<String> string, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodecs.object(NodeConsumerOfId::new, (String)"index", AbstractNode::getIndex, integer, (String)"id", NodeConsumerOfId::getId, string, (String)"partitionIndex", NodeConsumerOfId::getPartitionIndex, integer, (String)"maxPartitions", NodeConsumerOfId::getMaxPartitions, integer, (String)"input", NodeConsumerOfId::getInput, streamId);
    }

    @Provides
    StructuredCodec<NodeSort> nodeSort(StructuredCodec<Class<?>> cls, @CodecsModule.Subtypes StructuredCodec<Comparator> comparator, @CodecsModule.Subtypes StructuredCodec<Function> function, StructuredCodec<StreamId> streamId, StructuredCodec<Boolean> bool, StructuredCodec<Integer> integer) {
        return StructuredCodec.ofObject(in -> new NodeSort((Integer)in.readKey("index", (StructuredDecoder)integer), (Class)in.readKey("type", (StructuredDecoder)cls), (Function)in.readKey("keyFunction", (StructuredDecoder)function), (Comparator)in.readKey("keyComparator", (StructuredDecoder)comparator), (Boolean)in.readKey("deduplicate", (StructuredDecoder)bool), (Integer)in.readKey("itemsInMemorySize", (StructuredDecoder)integer), (StreamId)in.readKey("input", (StructuredDecoder)streamId), (StreamId)in.readKey("output", (StructuredDecoder)streamId)), (out, node) -> {
            out.writeKey("index", (StructuredEncoder)integer, (Object)node.getIndex());
            out.writeKey("type", (StructuredEncoder)cls, node.getType());
            out.writeKey("keyFunction", (StructuredEncoder)function, node.getKeyFunction());
            out.writeKey("keyComparator", (StructuredEncoder)comparator, node.getKeyComparator());
            out.writeKey("deduplicate", (StructuredEncoder)bool, (Object)node.isDeduplicate());
            out.writeKey("itemsInMemorySize", (StructuredEncoder)integer, (Object)node.getItemsInMemorySize());
            out.writeKey("input", (StructuredEncoder)streamId, (Object)node.getInput());
            out.writeKey("output", (StructuredEncoder)streamId, (Object)node.getOutput());
        });
    }

    @Provides
    StructuredCodec<NodeJoin> nodeJoin(@CodecsModule.Subtypes StructuredCodec<StreamJoin.Joiner> joiner, @CodecsModule.Subtypes StructuredCodec<Comparator> comparator, @CodecsModule.Subtypes StructuredCodec<Function> function, StructuredCodec<Integer> integer, StructuredCodec<StreamId> streamId) {
        return StructuredCodec.ofObject(in -> new NodeJoin((Integer)in.readKey("index", (StructuredDecoder)integer), (StreamId)in.readKey("left", (StructuredDecoder)streamId), (StreamId)in.readKey("right", (StructuredDecoder)streamId), (StreamId)in.readKey("output", (StructuredDecoder)streamId), (Comparator)in.readKey("keyComparator", (StructuredDecoder)comparator), (Function)in.readKey("leftKeyFunction", (StructuredDecoder)function), (Function)in.readKey("rightKeyFunction", (StructuredDecoder)function), (StreamJoin.Joiner)in.readKey("joiner", (StructuredDecoder)joiner)), (out, node) -> {
            out.writeKey("index", (StructuredEncoder)integer, (Object)node.getIndex());
            out.writeKey("left", (StructuredEncoder)streamId, (Object)node.getLeft());
            out.writeKey("right", (StructuredEncoder)streamId, (Object)node.getRight());
            out.writeKey("output", (StructuredEncoder)streamId, (Object)node.getOutput());
            out.writeKey("keyComparator", (StructuredEncoder)comparator, node.getKeyComparator());
            out.writeKey("leftKeyFunction", (StructuredEncoder)function, node.getLeftKeyFunction());
            out.writeKey("rightKeyFunction", (StructuredEncoder)function, node.getRightKeyFunction());
            out.writeKey("joiner", (StructuredEncoder)joiner, node.getJoiner());
        });
    }

    @Provides
    StructuredCodec<DataflowResponsePartitionData.TaskDesc> taskDesc(StructuredCodec<Long> longCodec, StructuredCodec<TaskStatus> status) {
        return StructuredCodecs.object(DataflowResponsePartitionData.TaskDesc::new, (String)"id", DataflowResponsePartitionData.TaskDesc::getId, longCodec, (String)"status", DataflowResponsePartitionData.TaskDesc::getStatus, status);
    }

    @Provides
    StructuredCodec<DataflowResponsePartitionData> partitionStats(StructuredCodec<List<DataflowResponsePartitionData.TaskDesc>> tasks, StructuredCodec<Integer> integer) {
        return StructuredCodecs.object(DataflowResponsePartitionData::new, (String)"running", DataflowResponsePartitionData::getRunning, integer, (String)"succeeded", DataflowResponsePartitionData::getSucceeded, integer, (String)"failed", DataflowResponsePartitionData::getFailed, integer, (String)"canceled", DataflowResponsePartitionData::getCanceled, integer, (String)"last", DataflowResponsePartitionData::getLast, tasks);
    }

    @Provides
    StructuredCodec<Instant> instant(StructuredCodec<Long> longCodec) {
        return longCodec.transform(Instant::ofEpochMilli, Instant::toEpochMilli);
    }

    @Provides
    StructuredCodec<DataflowResponseTaskData> localTaskStat(StructuredCodec<TaskStatus> status, StructuredCodec<Map<Integer, NodeStat>> nodes, StructuredCodec<String> string, StructuredCodec<Instant> instant) {
        return StructuredCodecs.object(DataflowResponseTaskData::new, (String)"status", DataflowResponseTaskData::getStatus, status, (String)"start", DataflowResponseTaskData::getStartTime, (StructuredCodec)instant.nullable(), (String)"finish", DataflowResponseTaskData::getFinishTime, (StructuredCodec)instant.nullable(), (String)"error", DataflowResponseTaskData::getErrorString, (StructuredCodec)string.nullable(), (String)"nodeStats", DataflowResponseTaskData::getNodes, nodes, (String)"graphviz", DataflowResponseTaskData::getGraphViz, string);
    }

    @Provides
    StructuredCodec<LocalTaskData> localTaskData(StructuredCodec<TaskStatus> status, StructuredCodec<String> string, StructuredCodec<List<Integer>> intList, StructuredCodec<Integer> integer, StructuredCodec<NodeStat> nodeStats, StructuredCodec<Instant> instant) {
        return StructuredCodecs.object(LocalTaskData::new, (String)"status", LocalTaskData::getStatus, status, (String)"graph", LocalTaskData::getGraph, string, (String)"nodeStats", LocalTaskData::getNodeStats, (StructuredCodec)StructuredCodecs.ofMap(integer, (StructuredCodec)nodeStats.nullable()), (String)"started", LocalTaskData::getStarted, (StructuredCodec)instant.nullable(), (String)"finished", LocalTaskData::getFinished, (StructuredCodec)instant.nullable(), (String)"error", LocalTaskData::getError, (StructuredCodec)string.nullable());
    }

    @Provides
    StructuredCodec<ReducedTaskData> reducedTaskData(StructuredCodec<TaskStatus> status, StructuredCodec<String> string, StructuredCodec<List<Integer>> intList, StructuredCodec<Integer> integer, StructuredCodec<NodeStat> nodeStats) {
        return StructuredCodecs.object(ReducedTaskData::new, (String)"statuses", ReducedTaskData::getStatuses, (StructuredCodec)StructuredCodecs.ofList((StructuredCodec)status.nullable()), (String)"graph", ReducedTaskData::getGraph, string, (String)"nodeStats", ReducedTaskData::getReducedNodeStats, (StructuredCodec)StructuredCodecs.ofMap(integer, (StructuredCodec)nodeStats.nullable()));
    }

    @Provides
    StructuredCodec<TestNodeStat> testNodeStats(StructuredCodec<Integer> integerCodec) {
        return StructuredCodecs.object(TestNodeStat::new, (String)"nodeIndex", TestNodeStat::getNodeIndex, integerCodec);
    }

    @Provides
    StructuredCodec<BinaryNodeStat> binaryNodeStats(StructuredCodec<Long> longint) {
        return StructuredCodecs.object(bytes -> {
            BinaryNodeStat stats = new BinaryNodeStat();
            stats.record((long)bytes);
            return stats;
        }, (String)"bytes", BinaryNodeStat::getBytes, longint);
    }

    @Provides
    CodecsModule.SubtypeNameFactory subtypeNames() {
        return subtype -> subtype == NATURAL_ORDER_CLASS ? "Comparator.naturalOrder" : null;
    }
}

