/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.inject.SortingExecutor;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamSorter;
import io.activej.datastream.processor.StreamSorterStorage;
import io.activej.inject.Key;
import io.activej.promise.Promise;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class NodeSort<K, T>
extends AbstractNode {
    private final Class<T> type;
    private final Function<T, K> keyFunction;
    private final Comparator<K> keyComparator;
    private final boolean deduplicate;
    private final int itemsInMemorySize;
    private final StreamId input;
    private final StreamId output;

    public NodeSort(int index, Class<T> type, Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate, int itemsInMemorySize, StreamId input) {
        this(index, type, keyFunction, keyComparator, deduplicate, itemsInMemorySize, input, new StreamId());
    }

    public NodeSort(int index, Class<T> type, Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate, int itemsInMemorySize, StreamId input, StreamId output) {
        super(index);
        this.type = type;
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.deduplicate = deduplicate;
        this.itemsInMemorySize = itemsInMemorySize;
        this.input = input;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        Executor executor = (Executor)task.get(Key.of(Executor.class, SortingExecutor.class));
        StreamSorterStorageFactory storageFactory = task.get(StreamSorterStorageFactory.class);
        StreamSorterStorage<T> storage = storageFactory.create(this.type, task, task.getExecutionPromise());
        StreamSorter streamSorter = StreamSorter.create(storage, this.keyFunction, this.keyComparator, (boolean)this.deduplicate, (int)this.itemsInMemorySize).withSortingExecutor(executor);
        task.bindChannel(this.input, streamSorter.getInput());
        task.export(this.output, streamSorter.getOutput());
    }

    public Class<T> getType() {
        return this.type;
    }

    public Function<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public int getItemsInMemorySize() {
        return this.itemsInMemorySize;
    }

    public StreamId getInput() {
        return this.input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeSort{type=" + this.type + ", keyFunction=" + this.keyFunction.getClass().getSimpleName() + ", keyComparator=" + this.keyComparator.getClass().getSimpleName() + ", deduplicate=" + this.deduplicate + ", itemsInMemorySize=" + this.itemsInMemorySize + ", input=" + this.input + ", output=" + this.output + '}';
    }

    public static interface StreamSorterStorageFactory {
        public <T> StreamSorterStorage<T> create(Class<T> var1, Task var2, Promise<Void> var3);
    }
}

