/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.csp.ChannelSupplier;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.dataflow.node.PartitionedStreamSupplierFactory;
import io.activej.datastream.StreamSupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;

public final class NodeSupplierOfId<T>
extends AbstractNode {
    private final String id;
    private final int partitionIndex;
    private final int maxPartitions;
    private final StreamId output;

    public NodeSupplierOfId(int index, String id, int partitionIndex, int maxPartitions) {
        this(index, id, partitionIndex, maxPartitions, new StreamId());
    }

    public NodeSupplierOfId(int index, String id, int partitionIndex, int maxPartitions, StreamId output) {
        super(index);
        this.id = id;
        this.partitionIndex = partitionIndex;
        this.maxPartitions = maxPartitions;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamSupplier supplier;
        Object object = task.get(this.id);
        if (object instanceof Iterator) {
            supplier = StreamSupplier.ofIterator((Iterator)((Iterator)object));
        } else if (object instanceof Iterable) {
            supplier = StreamSupplier.ofIterable((Iterable)((Iterable)object));
        } else if (object instanceof Stream) {
            supplier = StreamSupplier.ofStream((Stream)((Stream)object));
        } else if (object instanceof StreamSupplier) {
            supplier = (StreamSupplier)object;
        } else if (object instanceof ChannelSupplier) {
            supplier = StreamSupplier.ofChannelSupplier((ChannelSupplier)((ChannelSupplier)object));
        } else if (object instanceof PartitionedStreamSupplierFactory) {
            supplier = ((PartitionedStreamSupplierFactory)object).get(this.partitionIndex, this.maxPartitions);
        } else {
            throw new IllegalArgumentException("Object with id '" + this.id + "' is not a valid supplier of data: " + object);
        }
        task.export(this.output, supplier);
    }

    public String getId() {
        return this.id;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeSupplierOfId{id='" + this.id + "', partitionIndex=" + this.partitionIndex + ", maxPartitions=" + this.maxPartitions + ", output=" + this.output + '}';
    }
}

