/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset;

import io.activej.common.ref.RefInt;
import io.activej.common.tuple.Tuple2;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.StreamId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Dataset<T> {
    private final Class<T> valueType;

    public Dataset(Class<T> valueType) {
        this.valueType = valueType;
    }

    public final Class<T> valueType() {
        return this.valueType;
    }

    public abstract List<StreamId> channels(DataflowContext var1);

    public Collection<Dataset<?>> getBases() {
        return Collections.emptyList();
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        return (name.startsWith("Dataset") ? name.substring(7) : name) + "<" + this.valueType.getSimpleName() + ">";
    }

    private static void writeDatasets(StringBuilder sb, Map<Dataset<?>, String> ids, Set<Tuple2<Dataset<?>, Dataset<?>>> visited, RefInt lastId, Dataset<?> dataset) {
        for (Dataset<?> base : dataset.getBases()) {
            if (!visited.add(new Tuple2(base, dataset))) continue;
            sb.append("  ").append(ids.computeIfAbsent(base, $ -> "d" + lastId.value++)).append(" -> ").append(ids.computeIfAbsent(dataset, $ -> "d" + lastId.value++)).append('\n');
            Dataset.writeDatasets(sb, ids, visited, lastId, base);
        }
    }

    public final String toGraphViz() {
        StringBuilder sb = new StringBuilder("digraph {\n  node[shape=rect]\n\n");
        HashMap ids = new HashMap();
        Dataset.writeDatasets(sb, ids, new HashSet(), new RefInt(0), this);
        sb.append('\n');
        ids.forEach((dataset, id) -> sb.append("  ").append((String)id).append(" [label=\"").append(dataset).append("\"]\n"));
        return sb.append('}').toString();
    }
}

