/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.dataset.DatasetUtils;
import io.activej.dataflow.dataset.LocallySortedDataset;
import io.activej.dataflow.dataset.SortedDataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.Partition;
import io.activej.dataflow.graph.StreamId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class DatasetRepartitionAndSort<K, T>
extends SortedDataset<K, T> {
    private final LocallySortedDataset<K, T> input;
    @Nullable
    private final List<Partition> partitions;

    public DatasetRepartitionAndSort(LocallySortedDataset<K, T> input) {
        this(input, null);
    }

    public DatasetRepartitionAndSort(LocallySortedDataset<K, T> input, @Nullable List<Partition> partitions) {
        super(input.valueType(), input.keyComparator(), input.keyType(), input.keyFunction());
        this.input = input;
        this.partitions = partitions;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        List<Partition> ps = this.partitions != null && !this.partitions.isEmpty() ? this.partitions : context.getGraph().getAvailablePartitions();
        return DatasetUtils.repartitionAndSort(context, this.input, ps);
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

