/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.inject;

import io.activej.codec.CodecSubtype;
import io.activej.codec.StructuredCodec;
import io.activej.codec.StructuredCodecs;
import io.activej.common.tuple.Tuple1;
import io.activej.common.tuple.Tuple2;
import io.activej.common.tuple.Tuple3;
import io.activej.common.tuple.Tuple4;
import io.activej.common.tuple.Tuple5;
import io.activej.common.tuple.Tuple6;
import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.QualifierAnnotation;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.Dependency;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.inject.util.Types;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class CodecsModule
extends AbstractModule {
    private CodecsModule() {
    }

    public static Module create() {
        return new CodecsModule();
    }

    public static <T> Key<StructuredCodec<T>> codec(Class<T> itemClass) {
        return Key.ofType((Type)Types.parameterized(StructuredCodec.class, (Type[])new Type[]{itemClass}));
    }

    protected void configure() {
        this.bindPrimitive(Void.TYPE, StructuredCodecs.VOID_CODEC);
        this.bindPrimitive(Boolean.TYPE, StructuredCodecs.BOOLEAN_CODEC);
        this.bindPrimitive(Character.TYPE, StructuredCodecs.CHARACTER_CODEC);
        this.bindPrimitive(Byte.TYPE, StructuredCodecs.BYTE_CODEC);
        this.bindPrimitive(Integer.TYPE, StructuredCodecs.INT_CODEC);
        this.bindPrimitive(Long.TYPE, StructuredCodecs.LONG_CODEC);
        this.bindPrimitive(Float.TYPE, StructuredCodecs.FLOAT_CODEC);
        this.bindPrimitive(Double.TYPE, StructuredCodecs.DOUBLE_CODEC);
        this.bindPrimitive(Void.class, StructuredCodecs.VOID_CODEC);
        this.bindPrimitive(Boolean.class, StructuredCodecs.BOOLEAN_CODEC);
        this.bindPrimitive(Character.class, StructuredCodecs.CHARACTER_CODEC);
        this.bindPrimitive(Byte.class, StructuredCodecs.BYTE_CODEC);
        this.bindPrimitive(Integer.class, StructuredCodecs.INT_CODEC);
        this.bindPrimitive(Long.class, StructuredCodecs.LONG_CODEC);
        this.bindPrimitive(Float.class, StructuredCodecs.FLOAT_CODEC);
        this.bindPrimitive(Double.class, StructuredCodecs.DOUBLE_CODEC);
        this.bindPrimitive(String.class, StructuredCodecs.STRING_CODEC);
        this.bindPrimitive(byte[].class, StructuredCodecs.BYTES_CODEC);
        this.bind(new Key<StructuredCodec<Class<?>>>(){}).toInstance((Object)StructuredCodecs.CLASS_CODEC);
        this.generate(StructuredCodec.class, (bindings, scope, key) -> {
            Class type = key.getTypeParameter(0).getRawType();
            if (type.isEnum()) {
                return Binding.to(() -> StructuredCodecs.ofEnum((Class)type));
            }
            if (key.getQualifier() != Subtypes.class && !type.isAnnotationPresent(Subtypes.class)) {
                return null;
            }
            return Binding.to(args -> {
                Injector injector = (Injector)args[0];
                SubtypeNameFactory names = (SubtypeNameFactory)args[1];
                if (names == null) {
                    names = $ -> null;
                }
                HashSet<Class> subtypes = new HashSet<Class>();
                for (Injector i = injector; i != null; i = i.getParent()) {
                    for (Key k : i.getBindings().keySet()) {
                        Class subtype;
                        if (k.getRawType() != StructuredCodec.class || type == (subtype = k.getTypeParameter(0).getRawType()) || !type.isAssignableFrom(subtype)) continue;
                        subtypes.add(subtype);
                    }
                }
                CodecSubtype combined = CodecSubtype.create();
                for (Class subtype : subtypes) {
                    StructuredCodec codec = (StructuredCodec)injector.getInstance(Key.ofType((Type)Types.parameterized(StructuredCodec.class, (Type[])new Type[]{subtype})));
                    String name = names.getName(subtype);
                    if (name != null) {
                        combined.with((Type)subtype, name, codec);
                        continue;
                    }
                    combined.with((Type)subtype, codec);
                }
                return combined;
            }, (Dependency[])new Dependency[]{Dependency.toKey((Key)Key.of(Injector.class)), Dependency.toOptionalKey((Key)Key.of(SubtypeNameFactory.class))});
        });
    }

    private <T> void bindPrimitive(Class<T> cls, StructuredCodec<T> codec) {
        this.bind(Key.ofType((Type)Types.parameterized(StructuredCodec.class, (Type[])new Type[]{cls}))).toInstance(codec);
    }

    @Provides
    <T> StructuredCodec<Optional<T>> optional(StructuredCodec<T> itemCodec) {
        return StructuredCodecs.ofOptional(itemCodec);
    }

    @Provides
    <T> StructuredCodec<Set<T>> set(StructuredCodec<T> itemCodec) {
        return StructuredCodecs.ofSet(itemCodec);
    }

    @Provides
    <T> StructuredCodec<List<T>> list(StructuredCodec<T> itemCodec) {
        return StructuredCodecs.ofList(itemCodec);
    }

    @Provides
    <K, V> StructuredCodec<Map<K, V>> map(StructuredCodec<K> keyCodec, StructuredCodec<V> valueCodec) {
        return StructuredCodecs.ofMap(keyCodec, valueCodec);
    }

    @Provides
    <T1> StructuredCodec<Tuple1<T1>> tuple1(StructuredCodec<T1> codec1) {
        return StructuredCodecs.tuple(Tuple1::new, Tuple1::getValue1, codec1);
    }

    @Provides
    <T1, T2> StructuredCodec<Tuple2<T1, T2>> tuple2(StructuredCodec<T1> codec1, StructuredCodec<T2> codec2) {
        return StructuredCodecs.tuple(Tuple2::new, Tuple2::getValue1, codec1, Tuple2::getValue2, codec2);
    }

    @Provides
    <T1, T2, T3> StructuredCodec<Tuple3<T1, T2, T3>> tuple3(StructuredCodec<T1> codec1, StructuredCodec<T2> codec2, StructuredCodec<T3> codec3) {
        return StructuredCodecs.tuple(Tuple3::new, Tuple3::getValue1, codec1, Tuple3::getValue2, codec2, Tuple3::getValue3, codec3);
    }

    @Provides
    <T1, T2, T3, T4> StructuredCodec<Tuple4<T1, T2, T3, T4>> tuple4(StructuredCodec<T1> codec1, StructuredCodec<T2> codec2, StructuredCodec<T3> codec3, StructuredCodec<T4> codec4) {
        return StructuredCodecs.tuple(Tuple4::new, Tuple4::getValue1, codec1, Tuple4::getValue2, codec2, Tuple4::getValue3, codec3, Tuple4::getValue4, codec4);
    }

    @Provides
    <T1, T2, T3, T4, T5> StructuredCodec<Tuple5<T1, T2, T3, T4, T5>> tuple5(StructuredCodec<T1> codec1, StructuredCodec<T2> codec2, StructuredCodec<T3> codec3, StructuredCodec<T4> codec4, StructuredCodec<T5> codec5) {
        return StructuredCodecs.tuple(Tuple5::new, Tuple5::getValue1, codec1, Tuple5::getValue2, codec2, Tuple5::getValue3, codec3, Tuple5::getValue4, codec4, Tuple5::getValue5, codec5);
    }

    @Provides
    <T1, T2, T3, T4, T5, T6> StructuredCodec<Tuple6<T1, T2, T3, T4, T5, T6>> tuple6(StructuredCodec<T1> codec1, StructuredCodec<T2> codec2, StructuredCodec<T3> codec3, StructuredCodec<T4> codec4, StructuredCodec<T5> codec5, StructuredCodec<T6> codec6) {
        return StructuredCodecs.tuple(Tuple6::new, Tuple6::getValue1, codec1, Tuple6::getValue2, codec2, Tuple6::getValue3, codec3, Tuple6::getValue4, codec4, Tuple6::getValue5, codec5, Tuple6::getValue6, codec6);
    }

    @QualifierAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Subtypes {
    }

    @FunctionalInterface
    public static interface SubtypeNameFactory {
        @Nullable
        public String getName(Class<?> var1);
    }
}

