/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.inject;

import io.activej.dataflow.inject.DatasetId;
import io.activej.inject.Key;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import java.util.HashMap;
import java.util.Map;

public final class DatasetIdModule
extends AbstractModule {
    private DatasetIdModule() {
    }

    public static Module create() {
        return new DatasetIdModule();
    }

    protected void configure() {
        DatasetIds datasetIds = new DatasetIds();
        this.bind(DatasetIds.class).toInstance((Object)datasetIds);
        this.transform(0, (bindings, scope, key, binding) -> {
            String id;
            Key previousKey;
            if (key.getQualifier() instanceof DatasetId && (previousKey = datasetIds.keys.put(id = ((DatasetId)key.getQualifier()).value(), key)) != null && !previousKey.equals((Object)key)) {
                throw new IllegalStateException("More than one items provided for dataset id '" + id + "'");
            }
            return binding;
        });
    }

    public static final class DatasetIds {
        final Map<String, Key<?>> keys = new HashMap();

        public <T> Key<T> getKeyForId(String id) {
            Key<?> key = this.keys.get(id);
            if (key == null) {
                throw new IllegalStateException("No key for dataset id '" + id + "'");
            }
            return key;
        }
    }
}

