/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.DataflowServer;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.dataflow.stats.BinaryNodeStat;
import io.activej.dataflow.stats.NodeStat;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public final class NodeUpload<T>
extends AbstractNode {
    private final Class<T> type;
    private final StreamId streamId;
    private BinaryNodeStat stats;

    public NodeUpload(int index, Class<T> type, StreamId streamId) {
        super(index);
        this.type = type;
        this.streamId = streamId;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Collections.singletonList(this.streamId);
    }

    @Override
    public void createAndBind(Task task) {
        this.stats = new BinaryNodeStat();
        task.bindChannel(this.streamId, task.get(DataflowServer.class).upload(this.streamId, this.type, this.stats));
    }

    public Class<T> getType() {
        return this.type;
    }

    public StreamId getStreamId() {
        return this.streamId;
    }

    @Override
    @Nullable
    public NodeStat getStats() {
        return this.stats;
    }

    public String toString() {
        return "NodeUpload{type=" + this.type + ", streamId=" + this.streamId + '}';
    }
}

