/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.dataset.LocallySortedDataset;
import io.activej.dataflow.dataset.SortedDataset;
import io.activej.dataflow.dataset.impl.DatasetAlreadySorted;
import io.activej.dataflow.dataset.impl.DatasetConsumerOfId;
import io.activej.dataflow.dataset.impl.DatasetFilter;
import io.activej.dataflow.dataset.impl.DatasetJoin;
import io.activej.dataflow.dataset.impl.DatasetLocalSort;
import io.activej.dataflow.dataset.impl.DatasetLocalSortReduce;
import io.activej.dataflow.dataset.impl.DatasetMap;
import io.activej.dataflow.dataset.impl.DatasetRepartition;
import io.activej.dataflow.dataset.impl.DatasetRepartitionAndSort;
import io.activej.dataflow.dataset.impl.DatasetRepartitionReduce;
import io.activej.dataflow.dataset.impl.DatasetSplitSortReduceRepartitionReduce;
import io.activej.dataflow.dataset.impl.DatasetSupplierOfId;
import io.activej.dataflow.graph.Partition;
import io.activej.datastream.processor.StreamJoin;
import io.activej.datastream.processor.StreamReducers;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class Datasets {
    public static <K, T> SortedDataset<K, T> castToSorted(Dataset<T> dataset, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return new DatasetAlreadySorted<K, T>(dataset, keyComparator, keyType, keyFunction);
    }

    public static <K, T> SortedDataset<K, T> castToSorted(LocallySortedDataset<K, T> dataset) {
        return Datasets.castToSorted(dataset, dataset.keyType(), dataset.keyFunction(), dataset.keyComparator());
    }

    public static <K, L, R, V> SortedDataset<K, V> join(SortedDataset<K, L> left, SortedDataset<K, R> right, StreamJoin.Joiner<K, L, R, V> joiner, Class<V> resultType, Function<V, K> keyFunction) {
        return new DatasetJoin<K, L, R, V>(left, right, joiner, resultType, keyFunction);
    }

    public static <I, O> Dataset<O> map(Dataset<I> dataset, Function<I, O> mapper, Class<O> resultType) {
        return new DatasetMap<I, O>(dataset, mapper, resultType);
    }

    public static <T> Dataset<T> map(Dataset<T> dataset, UnaryOperator<T> mapper) {
        return Datasets.map(dataset, mapper, dataset.valueType());
    }

    public static <T> Dataset<T> filter(Dataset<T> dataset, Predicate<T> predicate) {
        return new DatasetFilter<T>(dataset, predicate, dataset.valueType());
    }

    public static <K, I> LocallySortedDataset<K, I> localSort(Dataset<I> dataset, Class<K> keyType, Function<I, K> keyFunction, Comparator<K> keyComparator, int sortBufferSize) {
        return new DatasetLocalSort<K, I>(dataset, keyType, keyFunction, keyComparator, sortBufferSize);
    }

    public static <K, I> LocallySortedDataset<K, I> localSort(Dataset<I> dataset, Class<K> keyType, Function<I, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.localSort(dataset, keyType, keyFunction, keyComparator, 1000000);
    }

    public static <K, I, O> LocallySortedDataset<K, O> localReduce(LocallySortedDataset<K, I> stream, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, Function<O, K> resultKeyFunction) {
        return new DatasetLocalSortReduce<K, I, O>(stream, reducer, resultType, resultKeyFunction);
    }

    public static <T, K> Dataset<T> repartition(Dataset<T> dataset, Function<T, K> keyFunction, List<Partition> partitions) {
        return new DatasetRepartition<T, K>(dataset, keyFunction, partitions);
    }

    public static <T, K> Dataset<T> repartition(Dataset<T> dataset, Function<T, K> keyFunction) {
        return new DatasetRepartition<T, K>(dataset, keyFunction, null);
    }

    public static <K, I, O> Dataset<O> repartitionReduce(LocallySortedDataset<K, I> dataset, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType) {
        return new DatasetRepartitionReduce<K, I, O>(dataset, reducer, resultType);
    }

    public static <K, I, O> Dataset<O> repartitionReduce(LocallySortedDataset<K, I> dataset, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, List<Partition> partitions) {
        return new DatasetRepartitionReduce<K, I, O>(dataset, reducer, resultType, partitions);
    }

    public static <K, T> SortedDataset<K, T> repartitionSort(LocallySortedDataset<K, T> dataset) {
        return new DatasetRepartitionAndSort<K, T>(dataset);
    }

    public static <K, T> SortedDataset<K, T> repartitionSort(LocallySortedDataset<K, T> dataset, List<Partition> partitions) {
        return new DatasetRepartitionAndSort<K, T>(dataset, partitions);
    }

    public static <K, I, O, A> Dataset<O> sortReduceRepartitionReduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, O, A> reducer, Class<K> keyType, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction, Class<O> outputType, int sortBufferSize) {
        LocallySortedDataset<K, I> partiallySorted = Datasets.localSort(dataset, keyType, inputKeyFunction, keyComparator, sortBufferSize);
        LocallySortedDataset<K, A> partiallyReduced = Datasets.localReduce(partiallySorted, reducer.inputToAccumulator(), accumulatorType, accumulatorKeyFunction);
        return Datasets.repartitionReduce(partiallyReduced, reducer.accumulatorToOutput(), outputType);
    }

    public static <K, I, O, A> Dataset<O> sortReduceRepartitionReduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, O, A> reducer, Class<K> keyType, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction, Class<O> outputType) {
        return Datasets.sortReduceRepartitionReduce(dataset, reducer, keyType, inputKeyFunction, keyComparator, accumulatorType, accumulatorKeyFunction, outputType, 1000000);
    }

    public static <K, I, A> Dataset<A> sortReduceRepartitionReduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, A, A> reducer, Class<K> keyType, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction) {
        return Datasets.sortReduceRepartitionReduce(dataset, reducer, keyType, inputKeyFunction, keyComparator, accumulatorType, accumulatorKeyFunction, accumulatorType);
    }

    public static <K, T> Dataset<T> sortReduceRepartitionReduce(Dataset<T> dataset, StreamReducers.ReducerToResult<K, T, T, T> reducer, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.sortReduceRepartitionReduce(dataset, reducer, keyType, keyFunction, keyComparator, dataset.valueType(), keyFunction, dataset.valueType());
    }

    public static <K, I, O, A> Dataset<O> splitSortReduceRepartitionReduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, O, A> reducer, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction, Class<O> outputType, int sortBufferSize) {
        return new DatasetSplitSortReduceRepartitionReduce<K, I, O, A>(dataset, inputKeyFunction, accumulatorKeyFunction, keyComparator, reducer, outputType, accumulatorType, sortBufferSize);
    }

    public static <K, I, A> Dataset<A> splitSortReduceRepartitionReduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, A, A> reducer, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction) {
        return Datasets.splitSortReduceRepartitionReduce(dataset, reducer, inputKeyFunction, keyComparator, accumulatorType, accumulatorKeyFunction, accumulatorType, 1000000);
    }

    public static <K, T> Dataset<T> splitSortReduceRepartitionReduce(Dataset<T> dataset, StreamReducers.ReducerToResult<K, T, T, T> reducer, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.splitSortReduceRepartitionReduce(dataset, reducer, keyFunction, keyComparator, dataset.valueType(), keyFunction, dataset.valueType(), 1000000);
    }

    public static <T> Dataset<T> datasetOfId(String dataId, Class<T> resultType) {
        return new DatasetSupplierOfId<T>(dataId, resultType);
    }

    public static <K, T> SortedDataset<K, T> sortedDatasetOfId(String dataId, Class<T> resultType, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.castToSorted(Datasets.datasetOfId(dataId, resultType), keyType, keyFunction, keyComparator);
    }

    public static <T> DatasetConsumerOfId<T> consumerOfId(Dataset<T> input, String listId) {
        return new DatasetConsumerOfId<T>(input, listId);
    }
}

