/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class DatasetFilter<T>
extends Dataset<T> {
    private final Dataset<T> input;
    private final Predicate<T> predicate;

    public DatasetFilter(Dataset<T> input, Predicate<T> predicate, Class<T> resultType) {
        super(resultType);
        this.input = input;
        this.predicate = predicate;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(context);
        int index = context.generateNodeIndex();
        for (StreamId streamId : streamIds) {
            NodeFilter<T> node = new NodeFilter<T>(index, this.predicate, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

