/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.dataset.impl;

import io.activej.dataflow.dataset.Dataset;
import io.activej.dataflow.graph.DataflowContext;
import io.activej.dataflow.graph.DataflowGraph;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.node.NodeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class DatasetMap<I, O>
extends Dataset<O> {
    private final Dataset<I> input;
    private final Function<I, O> mapper;

    public DatasetMap(Dataset<I> input, Function<I, O> mapper, Class<O> resultType) {
        super(resultType);
        this.input = input;
        this.mapper = mapper;
    }

    @Override
    public List<StreamId> channels(DataflowContext context) {
        DataflowGraph graph = context.getGraph();
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(context);
        int index = context.generateNodeIndex();
        for (StreamId streamId : streamIds) {
            NodeMap<I, O> node = new NodeMap<I, O>(index, this.mapper, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }

    @Override
    public Collection<Dataset<?>> getBases() {
        return Collections.singletonList(this.input);
    }
}

