/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.inject;

import io.activej.codegen.DefiningClassLoader;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.SerializerBuilder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinarySerializerModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(BinarySerializerModule.class);
    private final BinarySerializerLocator locator = new BinarySerializerLocator();

    private BinarySerializerModule() {
    }

    public static Module create() {
        return new BinarySerializerModule();
    }

    protected void configure() {
        this.transform(BinarySerializer.class, (bindings, scope, key, binding) -> {
            Class rawType = key.getTypeParameter(0).getRawType();
            return binding.mapInstance(serializer -> {
                this.locator.serializers.putIfAbsent(rawType, serializer);
                return serializer;
            });
        });
    }

    @Provides
    BinarySerializerLocator serializerLocator() {
        return this.locator;
    }

    @Provides
    <T> BinarySerializer<T> serializer(Key<T> t) {
        return this.locator.get(t.getRawType());
    }

    public static final class BinarySerializerLocator {
        private final Map<Class<?>, BinarySerializer<?>> serializers = new HashMap();
        @Nullable
        private SerializerBuilder builder = null;

        public <T> BinarySerializer<T> get(Class<T> cls) {
            return this.serializers.computeIfAbsent(cls, type -> {
                logger.info("Creating serializer for {}", type);
                if (this.builder == null) {
                    this.builder = SerializerBuilder.create((DefiningClassLoader)DefiningClassLoader.create((ClassLoader)Thread.currentThread().getContextClassLoader()));
                }
                return this.builder.build(type);
            });
        }
    }
}

