/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.inject;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.csp.binary.ByteBufsCodec;
import io.activej.csp.binary.ByteBufsDecoder;
import io.activej.dataflow.inject.BinarySerializerModule;
import io.activej.dataflow.inject.DatasetIdModule;
import io.activej.dataflow.json.JsonCodec;
import io.activej.dataflow.json.JsonModule;
import io.activej.dataflow.json.JsonUtils;
import io.activej.dataflow.stats.BinaryNodeStat;
import io.activej.dataflow.stats.StatReducer;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;

public final class DataflowModule
extends AbstractModule {
    private DataflowModule() {
    }

    public static Module create() {
        return new DataflowModule();
    }

    protected void configure() {
        this.install(JsonModule.create());
        this.install(DatasetIdModule.create());
        this.install(BinarySerializerModule.create());
        this.bind((Key)new Key<StatReducer<BinaryNodeStat>>(){}).toInstance(BinaryNodeStat.REDUCER);
    }

    @Provides
    <I, O> ByteBufsCodec<I, O> byteBufsCodec(@JsonModule.Subtypes JsonCodec<I> inputCodec, @JsonModule.Subtypes JsonCodec<O> outputCodec) {
        return ByteBufsCodec.ofDelimiter((ByteBufsDecoder)ByteBufsDecoder.ofNullTerminatedBytes(), buf -> {
            ByteBuf buf1 = ByteBufPool.ensureWriteRemaining((ByteBuf)buf, (int)1);
            buf1.put((byte)0);
            return buf1;
        }).andThen(buf -> JsonUtils.fromJson(inputCodec, buf), item -> JsonUtils.toJsonBuf(outputCodec, item));
    }
}

