/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.ParsingException;
import io.activej.dataflow.json.JsonCodec;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class JsonCodecSubtype<T>
implements JsonCodec<T> {
    private final Map<String, JsonCodec<? extends T>> namesToAdapters = new HashMap<String, JsonCodec<? extends T>>();
    private final Map<Class<? extends T>, String> subtypesToNames = new HashMap<Class<? extends T>, String>();

    private JsonCodecSubtype() {
    }

    public static <T> JsonCodecSubtype<T> create() {
        return new JsonCodecSubtype<T>();
    }

    public void setSubtypeCodec(Class<? extends T> type, String name, JsonCodec<? extends T> codec) {
        this.namesToAdapters.put(name, codec);
        this.subtypesToNames.put(type, name);
        if (codec instanceof JsonCodecSubtype) {
            this.namesToAdapters.putAll(((JsonCodecSubtype)codec).namesToAdapters);
            this.subtypesToNames.putAll(((JsonCodecSubtype)codec).subtypesToNames);
        }
    }

    public void setSubtypeCodec(Class<? extends T> type, JsonCodec<? extends T> codec) {
        String name = type.getTypeName();
        name = name.substring(Math.max(name.lastIndexOf(46), name.lastIndexOf(36)) + 1);
        this.setSubtypeCodec(type, name, codec);
    }

    public void write(@NotNull JsonWriter writer, T value) {
        if (value == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)123);
        String tag = this.subtypesToNames.get(value.getClass());
        if (tag == null) {
            throw new IllegalArgumentException("Unregistered data type: " + value.getClass().getName());
        }
        JsonCodec<? extends T> codec = this.namesToAdapters.get(tag);
        writer.writeString(tag);
        writer.writeByte((byte)58);
        codec.write(writer, value);
        writer.writeByte((byte)125);
    }

    public T read(@NotNull JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() != 123) {
            throw reader.newParseError("Expected '{'");
        }
        reader.getNextToken();
        String key = reader.readKey();
        JsonCodec<? extends T> codec = this.namesToAdapters.get(key);
        if (codec == null) {
            throw ParsingException.create((String)("Could not find codec for: " + key), (boolean)true);
        }
        Object result = codec.read(reader);
        reader.endObject();
        return (T)result;
    }
}

