/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.json;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonConverter;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.ParsingException;
import com.dslplatform.json.runtime.Settings;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.exception.MalformedDataException;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.json.JsonCodec;
import io.activej.inject.Key;
import io.activej.inject.util.Constructors;
import io.activej.types.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public final class JsonUtils {
    static final DslJson<?> DSL_JSON = new DslJson(Settings.withRuntime().includeServiceLoader());
    private static final ThreadLocal<JsonWriter> WRITERS = ThreadLocal.withInitial(() -> DSL_JSON.newWriter());
    private static final ThreadLocal<JsonReader<?>> READERS = ThreadLocal.withInitial(() -> DSL_JSON.newReader());

    public static <T> ByteBuf toJsonBuf(@NotNull JsonWriter.WriteObject<? super T> writeObject, @Nullable T object) {
        return ByteBuf.wrapForReading((byte[])JsonUtils.toJsonWriter(writeObject, object).toByteArray());
    }

    public static <T> String toJson(@NotNull JsonWriter.WriteObject<? super T> writeObject, @Nullable T object) {
        return JsonUtils.toJsonWriter(writeObject, object).toString();
    }

    private static <T> JsonWriter toJsonWriter(@NotNull JsonWriter.WriteObject<? super T> writeObject, @Nullable T object) {
        JsonWriter jsonWriter = WRITERS.get();
        jsonWriter.reset();
        writeObject.write(jsonWriter, object);
        return jsonWriter;
    }

    public static <T> T fromJson(@NotNull JsonReader.ReadObject<? extends T> readObject, @NotNull ByteBuf json) throws MalformedDataException {
        return JsonUtils.fromJson(readObject, json.asArray());
    }

    private static <T> T fromJson(@NotNull JsonReader.ReadObject<? extends T> readObject, byte[] jsonBytes) throws MalformedDataException {
        try {
            JsonReader<?> jsonReader = READERS.get();
            jsonReader.process(jsonBytes, jsonBytes.length);
            jsonReader.getNextToken();
            Object deserialized = readObject.read(jsonReader);
            if (jsonReader.length() != jsonReader.getCurrentIndex()) {
                String unexpectedData = jsonReader.toString().substring(jsonReader.getCurrentIndex());
                throw new MalformedDataException("Unexpected JSON data: " + unexpectedData);
            }
            return (T)deserialized;
        }
        catch (ParsingException e) {
            throw new MalformedDataException((Throwable)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> Key<JsonCodec<T>> codec(Class<? extends T> aClass) {
        return Key.ofType((Type)Types.parameterizedType(JsonCodec.class, (Type[])new Type[]{aClass}));
    }

    public static <T> JsonCodec<T> ofObject(Constructors.Constructor0<T> constructor) {
        return JsonCodec.of(reader -> {
            if (reader.last() != 123) {
                throw reader.newParseError("Expected '{'");
            }
            reader.endObject();
            return constructor.create();
        }, (writer, value) -> {
            writer.writeByte((byte)123);
            writer.writeByte((byte)125);
        });
    }

    @JsonConverter(target=Instant.class)
    public static class InstantConverter {
        public static final JsonReader.ReadObject<Instant> JSON_READER = reader -> Instant.ofEpochMilli((Long)NumberConverter.LONG_READER.read(reader));
        public static final JsonWriter.WriteObject<Instant> JSON_WRITER = (writer, value) -> NumberConverter.LONG_WRITER.write(writer, (Object)value.toEpochMilli());
    }

    @JsonConverter(target=StreamId.class)
    public static class StreamIdConverter {
        public static final JsonReader.ReadObject<StreamId> JSON_READER = reader -> new StreamId(NumberConverter.deserializeLong((JsonReader)reader));
        public static final JsonWriter.WriteObject<StreamId> JSON_WRITER = (writer, value) -> {
            if (value == null) {
                writer.writeNull();
            } else {
                NumberConverter.serialize((long)value.getId(), (JsonWriter)writer);
            }
        };
    }
}

