/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.DataflowException;
import io.activej.dataflow.node.Node;
import io.activej.dataflow.stats.NodeStat;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNode
implements Node {
    private final int index;
    @Nullable
    protected Instant finished = null;
    @Nullable
    protected Exception error = null;

    protected AbstractNode(int index) {
        this.index = index;
    }

    @Override
    public void finish(@Nullable Exception e) {
        if (e != null && !(e instanceof DataflowException)) {
            e = new DataflowException(e);
        }
        this.error = e;
        this.finished = Instant.now();
    }

    @Override
    @Nullable
    public Instant getFinished() {
        return this.finished;
    }

    @Override
    @Nullable
    public Exception getError() {
        return this.error;
    }

    @Override
    @Nullable
    public NodeStat getStats() {
        return null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

