/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import com.dslplatform.json.CompiledJson;
import io.activej.async.function.AsyncConsumer;
import io.activej.common.function.ConsumerEx;
import io.activej.csp.ChannelConsumer;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.dataflow.node.PartitionedStreamConsumerFactory;
import io.activej.datastream.StreamConsumer;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;

@CompiledJson
public final class NodeConsumerOfId<T>
extends AbstractNode {
    private final String id;
    private final int partitionIndex;
    private final int maxPartitions;
    private final StreamId input;

    public NodeConsumerOfId(int index, String id, int partitionIndex, int maxPartitions, StreamId input) {
        super(index);
        this.id = id;
        this.partitionIndex = partitionIndex;
        this.maxPartitions = maxPartitions;
        this.input = input;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public void createAndBind(Task task) {
        StreamConsumer streamConsumer;
        Object object = task.get(this.id);
        if (object instanceof Collection) {
            streamConsumer = StreamConsumer.ofConsumer(((Collection)object)::add);
        } else if (object instanceof Consumer) {
            streamConsumer = StreamConsumer.ofConsumer(((Consumer)object)::accept);
        } else if (object instanceof ConsumerEx) {
            streamConsumer = StreamConsumer.ofConsumer((ConsumerEx)((ConsumerEx)object));
        } else if (object instanceof AsyncConsumer) {
            streamConsumer = StreamConsumer.ofChannelConsumer((ChannelConsumer)ChannelConsumer.of((AsyncConsumer)((AsyncConsumer)object)));
        } else if (object instanceof ChannelConsumer) {
            streamConsumer = StreamConsumer.ofChannelConsumer((ChannelConsumer)((ChannelConsumer)object));
        } else if (object instanceof StreamConsumer) {
            streamConsumer = (StreamConsumer)object;
        } else if (object instanceof PartitionedStreamConsumerFactory) {
            streamConsumer = ((PartitionedStreamConsumerFactory)object).get(this.partitionIndex, this.maxPartitions);
        } else {
            throw new IllegalStateException("Object with id " + this.id + " is not a valid consumer of data: " + object);
        }
        task.bindChannel(this.input, streamConsumer);
    }

    public String getId() {
        return this.id;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    public StreamId getInput() {
        return this.input;
    }

    public String toString() {
        return "NodeConsumerOfId{id='" + this.id + '\'' + ", partitionIndex=" + this.partitionIndex + ", maxPartitions=" + this.maxPartitions + ", input=" + this.input + '}';
    }
}

