/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.DataflowClient;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.dataflow.stats.BinaryNodeStat;
import io.activej.dataflow.stats.NodeStat;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public final class NodeDownload<T>
extends AbstractNode {
    private final Class<T> type;
    private final InetSocketAddress address;
    private final StreamId streamId;
    private final StreamId output;
    private BinaryNodeStat stats;

    public NodeDownload(int index, Class<T> type, InetSocketAddress address, StreamId streamId) {
        this(index, type, address, streamId, new StreamId());
    }

    public NodeDownload(int index, Class<T> type, InetSocketAddress address, StreamId streamId, StreamId output) {
        super(index);
        this.type = type;
        this.address = address;
        this.streamId = streamId;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.streamId);
    }

    @Override
    public void createAndBind(Task task) {
        this.stats = new BinaryNodeStat();
        task.export(this.output, task.get(DataflowClient.class).download(this.address, this.streamId, this.type, this.stats));
    }

    public Class<T> getType() {
        return this.type;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public StreamId getStreamId() {
        return this.streamId;
    }

    public StreamId getOutput() {
        return this.output;
    }

    @Override
    @Nullable
    public NodeStat getStats() {
        return this.stats;
    }

    public String toString() {
        return "NodeDownload{type=" + this.type + ", address=" + this.address + ", streamId=" + this.streamId + ", output=" + this.output + '}';
    }
}

