/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamJoin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;

public final class NodeJoin<K, L, R, V>
extends AbstractNode {
    private final StreamId left;
    private final StreamId right;
    private final StreamId output;
    private final Comparator<K> keyComparator;
    private final Function<L, K> leftKeyFunction;
    private final Function<R, K> rightKeyFunction;
    private final StreamJoin.Joiner<K, L, R, V> joiner;

    public NodeJoin(int index, StreamId left, StreamId right, Comparator<K> keyComparator, Function<L, K> leftKeyFunction, Function<R, K> rightKeyFunction, StreamJoin.Joiner<K, L, R, V> joiner) {
        this(index, left, right, new StreamId(), keyComparator, leftKeyFunction, rightKeyFunction, joiner);
    }

    public NodeJoin(int index, StreamId left, StreamId right, StreamId output, Comparator<K> keyComparator, Function<L, K> leftKeyFunction, Function<R, K> rightKeyFunction, StreamJoin.Joiner<K, L, R, V> joiner) {
        super(index);
        this.left = left;
        this.right = right;
        this.output = output;
        this.keyComparator = keyComparator;
        this.leftKeyFunction = leftKeyFunction;
        this.rightKeyFunction = rightKeyFunction;
        this.joiner = joiner;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamJoin join = StreamJoin.create(this.keyComparator, this.leftKeyFunction, this.rightKeyFunction, this.joiner);
        task.bindChannel(this.left, join.getLeft());
        task.bindChannel(this.right, join.getRight());
        task.export(this.output, join.getOutput());
    }

    public StreamId getLeft() {
        return this.left;
    }

    public StreamId getRight() {
        return this.right;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public Function<L, K> getLeftKeyFunction() {
        return this.leftKeyFunction;
    }

    public Function<R, K> getRightKeyFunction() {
        return this.rightKeyFunction;
    }

    public StreamJoin.Joiner<K, L, R, V> getJoiner() {
        return this.joiner;
    }

    public String toString() {
        return "NodeJoin{left=" + this.left + ", right=" + this.right + ", output=" + this.output + ", keyComparator=" + this.keyComparator.getClass().getSimpleName() + ", leftKeyFunction=" + this.leftKeyFunction.getClass().getSimpleName() + ", rightKeyFunction=" + this.rightKeyFunction.getClass().getSimpleName() + ", joiner=" + this.joiner.getClass().getSimpleName() + '}';
    }
}

