/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public final class NodeMap<I, O>
extends AbstractNode {
    private final Function<I, O> function;
    private final StreamId input;
    private final StreamId output;

    public NodeMap(int index, Function<I, O> function, StreamId input) {
        this(index, function, input, new StreamId());
    }

    public NodeMap(int index, Function<I, O> function, StreamId input, StreamId output) {
        super(index);
        this.function = function;
        this.input = input;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamFilter streamMap = StreamFilter.mapper(this.function);
        task.bindChannel(this.input, streamMap.getInput());
        task.export(this.output, streamMap.getOutput());
    }

    public Function<I, O> getFunction() {
        return this.function;
    }

    public StreamId getInput() {
        return this.input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeMap{mapper=" + this.function.getClass().getSimpleName() + ", input=" + this.input + ", output=" + this.output + '}';
    }
}

