/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamReducer;
import io.activej.datastream.processor.StreamReducers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class NodeMerge<K, T>
extends AbstractNode {
    private final Function<T, K> keyFunction;
    private final Comparator<K> keyComparator;
    private final boolean deduplicate;
    private final List<StreamId> inputs;
    private final StreamId output;

    public NodeMerge(int index, Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate) {
        this(index, keyFunction, keyComparator, deduplicate, new ArrayList<StreamId>(), new StreamId());
    }

    public NodeMerge(int index, Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate, List<StreamId> inputs, StreamId output) {
        super(index);
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.deduplicate = deduplicate;
        this.inputs = inputs;
        this.output = output;
    }

    public void addInput(StreamId input) {
        this.inputs.add(input);
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamReducer streamMerger = StreamReducer.create(this.keyComparator);
        for (StreamId input : this.inputs) {
            task.bindChannel(input, streamMerger.newInput(this.keyFunction, this.deduplicate ? StreamReducers.deduplicateReducer() : StreamReducers.mergeReducer()));
        }
        task.export(this.output, streamMerger.getOutput());
    }

    public Function<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeMerge{keyFunction=" + this.keyFunction.getClass().getSimpleName() + ", keyComparator=" + this.keyComparator.getClass().getSimpleName() + ", deduplicate=" + this.deduplicate + ", inputs=" + this.inputs + ", output=" + this.output + '}';
    }
}

