/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamReducer;
import io.activej.datastream.processor.StreamReducers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class NodeReduceSimple<K, I, O, A>
extends AbstractNode {
    private final Function<I, K> keyFunction;
    private final Comparator<K> keyComparator;
    private final StreamReducers.Reducer<K, I, O, A> reducer;
    private final List<StreamId> inputs;
    private final StreamId output;

    public NodeReduceSimple(int index, Function<I, K> keyFunction, Comparator<K> keyComparator, StreamReducers.Reducer<K, I, O, A> reducer) {
        this(index, keyFunction, keyComparator, reducer, new ArrayList<StreamId>(), new StreamId());
    }

    public NodeReduceSimple(int index, Function<I, K> keyFunction, Comparator<K> keyComparator, StreamReducers.Reducer<K, I, O, A> reducer, List<StreamId> inputs, StreamId output) {
        super(index);
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.reducer = reducer;
        this.inputs = inputs;
        this.output = output;
    }

    public void addInput(StreamId input) {
        this.inputs.add(input);
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamReducer streamReducerSimple = StreamReducer.create(this.keyComparator);
        for (StreamId input : this.inputs) {
            task.bindChannel(input, streamReducerSimple.newInput(this.keyFunction, this.reducer));
        }
        task.export(this.output, streamReducerSimple.getOutput());
    }

    public Function<I, K> getKeyFunction() {
        return this.keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public StreamReducers.Reducer<K, I, O, A> getReducer() {
        return this.reducer;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeReduceSimple{keyFunction=" + this.keyFunction.getClass().getSimpleName() + ", keyComparator=" + this.keyComparator.getClass().getSimpleName() + ", reducer=" + this.reducer.getClass().getSimpleName() + ", inputs=" + this.inputs + ", output=" + this.output + '}';
    }
}

