/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.node;

import com.dslplatform.json.CompiledJson;
import io.activej.dataflow.graph.StreamId;
import io.activej.dataflow.graph.Task;
import io.activej.dataflow.node.AbstractNode;
import io.activej.datastream.processor.StreamUnion;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@CompiledJson
public final class NodeUnion<T>
extends AbstractNode {
    private final List<StreamId> inputs;
    private final StreamId output;

    public NodeUnion(int index, List<StreamId> inputs) {
        this(index, inputs, new StreamId());
    }

    public NodeUnion(int index, List<StreamId> inputs, StreamId output) {
        super(index);
        this.inputs = inputs;
        this.output = output;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(Task task) {
        StreamUnion streamUnion = StreamUnion.create();
        for (StreamId input : this.inputs) {
            task.bindChannel(input, streamUnion.newInput());
        }
        task.export(this.output, streamUnion.getOutput());
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public String toString() {
        return "NodeUnion{inputs=" + this.inputs + ", output=" + this.output + '}';
    }
}

