/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dataflow.stats;

import com.dslplatform.json.CompiledJson;
import io.activej.bytebuf.ByteBuf;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.ChannelTransformer;
import io.activej.dataflow.stats.NodeStat;
import io.activej.dataflow.stats.StatReducer;
import java.util.Objects;

@CompiledJson
public class BinaryNodeStat
extends NodeStat
implements ChannelTransformer<ByteBuf, ByteBuf> {
    public static final StatReducer<BinaryNodeStat> REDUCER = stats -> {
        long sum = stats.stream().filter(Objects::nonNull).mapToLong(BinaryNodeStat::getBytes).reduce(0L, Long::sum);
        BinaryNodeStat stat = new BinaryNodeStat();
        stat.record(sum);
        return stat;
    };
    private long bytes = 0L;

    public BinaryNodeStat() {
    }

    public BinaryNodeStat(long bytes) {
        this.bytes = bytes;
    }

    public void record(long bytes) {
        this.bytes += bytes;
    }

    public ChannelConsumer<ByteBuf> transform(ChannelConsumer<ByteBuf> consumer) {
        return consumer.peek(buf -> this.record(buf.readRemaining()));
    }

    public ChannelSupplier<ByteBuf> transform(ChannelSupplier<ByteBuf> supplier) {
        return supplier.peek(buf -> this.record(buf.readRemaining()));
    }

    public long getBytes() {
        return this.bytes;
    }

    public String toString() {
        return Long.toString(this.bytes);
    }
}

