/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import io.activej.common.Checks;
import io.activej.json.JsonCodec;
import io.activej.json.JsonDecoder;
import io.activej.json.JsonEncoder;
import io.activej.json.JsonValidationException;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractArrayJsonCodec<T, A, V>
implements JsonCodec<T> {
    protected abstract Iterator<V> iterate(T var1);

    @Nullable
    protected abstract JsonEncoder<V> encoder(int var1, T var2, V var3);

    @Nullable
    protected abstract JsonDecoder<V> decoder(int var1, A var2) throws JsonValidationException;

    protected abstract A accumulator();

    protected abstract void accumulate(A var1, int var2, V var3) throws JsonValidationException;

    protected abstract T result(A var1, int var2) throws JsonValidationException;

    @Override
    public void write(JsonWriter writer, T item) {
        Checks.checkNotNull(item);
        writer.writeByte((byte)91);
        boolean comma = false;
        int i = 0;
        Iterator<V> iterator = this.iterate(item);
        while (iterator.hasNext()) {
            JsonEncoder<V> encoder;
            V value = iterator.next();
            if ((encoder = this.encoder(i++, item, value)) == null) continue;
            if (comma) {
                writer.writeByte((byte)44);
            }
            encoder.write(writer, value);
            comma = true;
        }
        writer.writeByte((byte)93);
    }

    @Override
    public T read(JsonReader<?> reader) throws IOException {
        if (reader.last() != 91) {
            throw reader.newParseError("Expected '['");
        }
        A accumulator = this.accumulator();
        int i = 0;
        if (reader.getNextToken() != 93) {
            while (true) {
                JsonDecoder<V> decoder;
                if ((decoder = this.decoder(i, accumulator)) == null) {
                    reader.skip();
                    continue;
                }
                V value = decoder.read(reader);
                this.accumulate(accumulator, i++, value);
                if (reader.getNextToken() != 44) break;
                reader.getNextToken();
            }
            reader.checkArrayEnd();
        }
        return this.result(accumulator, i);
    }
}

