/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import io.activej.common.Checks;
import io.activej.json.JsonCodec;
import io.activej.json.JsonDecoder;
import io.activej.json.JsonEncoder;
import io.activej.json.JsonKeyEncoder;
import io.activej.json.JsonValidationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMapJsonCodec<T, A, V>
implements JsonCodec<T> {
    protected abstract Iterator<JsonMapEntry<V>> iterate(T var1);

    @Nullable
    protected abstract JsonEncoder<V> encoder(String var1, int var2, T var3, V var4);

    @Nullable
    protected abstract JsonDecoder<V> decoder(String var1, int var2, A var3) throws JsonValidationException;

    protected abstract A accumulator();

    protected abstract void accumulate(A var1, String var2, int var3, V var4) throws JsonValidationException;

    protected abstract T result(A var1, int var2) throws JsonValidationException;

    @Override
    public final void write(JsonWriter writer, T item) {
        Checks.checkNotNull(item);
        writer.writeByte((byte)123);
        boolean comma = false;
        Iterator<JsonMapEntry<V>> iterator = this.iterate(item);
        int i = 0;
        while (iterator.hasNext()) {
            JsonEncoder encoder;
            JsonMapEntry<V> entry = iterator.next();
            String key = entry.key;
            Object value = entry.value;
            if ((encoder = this.encoder(key, i++, item, value)) == null) continue;
            if (comma) {
                writer.writeByte((byte)44);
            }
            writer.writeString(key);
            writer.writeByte((byte)58);
            encoder.write(writer, value);
            comma = true;
        }
        writer.writeByte((byte)125);
    }

    @Override
    public final T read(JsonReader<?> reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expected '{'");
        }
        A accumulator = this.accumulator();
        int i = 0;
        if (reader.getNextToken() != 125) {
            while (true) {
                String key;
                JsonDecoder<V> decoder;
                if ((decoder = this.decoder(key = reader.readKey(), i, accumulator)) == null) {
                    reader.skip();
                    continue;
                }
                V value = decoder.read(reader);
                this.accumulate(accumulator, key, i++, value);
                if (reader.getNextToken() != 44) break;
                reader.getNextToken();
            }
            reader.checkObjectEnd();
        }
        return this.result(accumulator, i);
    }

    public record JsonMapEntry<V>(String key, V value) {
        public static <V> JsonMapEntry<V> of(Map.Entry<String, V> mapEntry) {
            return new JsonMapEntry<V>(mapEntry.getKey(), mapEntry.getValue());
        }

        public static <K, V> JsonMapEntry<V> of(Map.Entry<K, V> mapEntry, JsonKeyEncoder<K> keyEncoder) {
            return new JsonMapEntry<V>(keyEncoder.encode(mapEntry.getKey()), mapEntry.getValue());
        }
    }
}

