/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.builder.Rebuildable;
import io.activej.json.JsonCodec;
import io.activej.json.JsonCodecs;
import io.activej.json.JsonKeyCodec;
import io.activej.json.SubclassJsonCodec;
import io.activej.json.annotations.JsonNullable;
import io.activej.json.annotations.JsonSubclasses;
import io.activej.types.TypeT;
import io.activej.types.Utils;
import io.activej.types.scanner.TypeScannerRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class JsonCodecFactory
implements Rebuildable<JsonCodecFactory, Builder> {
    private static final JsonCodecFactory DEFAULT_INSTANCE = (JsonCodecFactory)JsonCodecFactory.builder().build();
    private final TypeScannerRegistry<JsonCodec<?>> registry;

    private JsonCodecFactory(TypeScannerRegistry<JsonCodec<?>> registry) {
        this.registry = registry;
    }

    public static JsonCodecFactory defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder builder() {
        JsonCodecFactory factory = new JsonCodecFactory(TypeScannerRegistry.create());
        return factory.new Builder().with((Type)((Object)String.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofString())).with(Byte.TYPE, ctx -> JsonCodecs.ofByte()).with(Short.TYPE, ctx -> JsonCodecs.ofShort()).with(Integer.TYPE, ctx -> JsonCodecs.ofInteger()).with(Long.TYPE, ctx -> JsonCodecs.ofLong()).with(Float.TYPE, ctx -> JsonCodecs.ofFloat()).with(Double.TYPE, ctx -> JsonCodecs.ofDouble()).with(Boolean.TYPE, ctx -> JsonCodecs.ofBoolean()).with(Character.TYPE, ctx -> JsonCodecs.ofCharacter()).with((Type)((Object)Byte.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofByte())).with((Type)((Object)Short.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofShort())).with((Type)((Object)Integer.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofInteger())).with((Type)((Object)Long.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofLong())).with((Type)((Object)Float.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofFloat())).with((Type)((Object)Double.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofDouble())).with((Type)((Object)Boolean.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofBoolean())).with((Type)((Object)Character.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofCharacter())).with((Type)((Object)LocalDate.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofLocalDate())).with((Type)((Object)Enum.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofEnum(ctx.getRawType()))).with((Type)((Object)List.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> JsonCodecs.ofList((JsonCodec)ctx.scanTypeArgument(0)))).with((Type)((Object)Map.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> {
            AnnotatedType keyAnnotatedType = ctx.getTypeArgument(0);
            Class keyType = (Class)keyAnnotatedType.getType();
            if (keyAnnotatedType.getAnnotations().length == 0 && keyType == String.class) {
                return JsonCodecs.ofMap((JsonCodec)ctx.scanTypeArgument(1));
            }
            if (Number.class.isAssignableFrom(keyType)) {
                JsonKeyCodec keyCodec = JsonKeyCodec.ofNumberKey(keyType);
                return JsonCodecs.ofMap(keyCodec, (JsonCodec)ctx.scanTypeArgument(1));
            }
            throw new IllegalArgumentException("TODO");
        })).with((Type)((Object)Object.class), (TypeScannerRegistry.Mapping<JsonCodec<?>>)((TypeScannerRegistry.Mapping)ctx -> {
            throw new UnsupportedOperationException();
        }));
    }

    public Builder rebuild() {
        return new JsonCodecFactory(TypeScannerRegistry.copyOf(this.registry)).new Builder();
    }

    public <T> JsonCodec<T> resolve(Class<T> type) {
        return (JsonCodec)this.registry.scanner().scan(type);
    }

    public <T> JsonCodec<T> resolve(Type type) {
        return (JsonCodec)this.registry.scanner().scan(type);
    }

    public <T> JsonCodec<T> resolve(TypeT<T> type) {
        return (JsonCodec)this.registry.scanner().scan(type.getAnnotatedType());
    }

    public final class Builder
    extends AbstractBuilder<Builder, JsonCodecFactory> {
        private Builder() {
        }

        public Builder with(TypeT<?> typeT, TypeScannerRegistry.Mapping<JsonCodec<?>> fn) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.with(typeT.getType(), fn);
        }

        public Builder with(Type type, TypeScannerRegistry.Mapping<JsonCodec<?>> fn) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            JsonCodecFactory.this.registry.with(type, ctx -> {
                JsonCodec jsonCodec;
                JsonSubclasses annotation = (JsonSubclasses)Utils.getAnnotation((Annotation[])ctx.getAnnotations(), JsonSubclasses.class);
                if (annotation != null) {
                    SubclassJsonCodec.Builder subclassBuilder = SubclassJsonCodec.builder();
                    Class<?>[] subclasses = annotation.value();
                    String[] tags = annotation.tags();
                    Checks.checkArgument((tags.length == 0 || tags.length == subclasses.length ? 1 : 0) != 0);
                    for (int i = 0; i < subclasses.length; ++i) {
                        Class<?> subclass = subclasses[i];
                        JsonCodec codec = (JsonCodec)ctx.scan(subclass);
                        if (tags.length != 0) {
                            subclassBuilder.with(subclass, tags[i], codec);
                            continue;
                        }
                        subclassBuilder.with(subclass, codec);
                    }
                    jsonCodec = (JsonCodec)subclassBuilder.build();
                } else {
                    jsonCodec = (JsonCodec)fn.apply(ctx);
                }
                if (Utils.hasAnnotation((Annotation[])ctx.getAnnotations(), JsonNullable.class) && !(jsonCodec instanceof JsonCodecs.NullableJsonCodec)) {
                    jsonCodec = jsonCodec.nullable();
                }
                return jsonCodec;
            });
            return this;
        }

        protected JsonCodecFactory doBuild() {
            return JsonCodecFactory.this;
        }
    }
}

