/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import io.activej.json.JsonKeyDecoder;
import io.activej.json.JsonKeyEncoder;
import io.activej.json.JsonValidationException;

public interface JsonKeyCodec<T>
extends JsonKeyEncoder<T>,
JsonKeyDecoder<T> {
    @Override
    public String encode(T var1);

    @Override
    public T decode(String var1) throws JsonValidationException;

    public static <T> JsonKeyCodec<T> of(final JsonKeyEncoder<T> encoder, final JsonKeyDecoder<T> decoder) {
        return new JsonKeyCodec<T>(){

            @Override
            public String encode(T value) {
                return encoder.encode(value);
            }

            @Override
            public T decode(String string) throws JsonValidationException {
                return decoder.decode(string);
            }
        };
    }

    public static JsonKeyCodec<String> ofStringKey() {
        return new JsonKeyCodec<String>(){

            @Override
            public String encode(String value) {
                return value;
            }

            @Override
            public String decode(String string) throws JsonValidationException {
                return string;
            }
        };
    }

    public static <T extends Number> JsonKeyCodec<T> ofNumberKey(final Class<T> type) {
        return new JsonKeyCodec<T>(){
            private final NumberParser<?> parser;
            {
                if (type == Byte.class) {
                    this.parser = Byte::parseByte;
                } else if (type == Short.class) {
                    this.parser = Short::parseShort;
                } else if (type == Integer.class) {
                    this.parser = Integer::parseInt;
                } else if (type == Long.class) {
                    this.parser = Long::parseLong;
                } else if (type == Float.class) {
                    this.parser = Float::parseFloat;
                } else if (type == Double.class) {
                    this.parser = Double::parseDouble;
                } else {
                    throw new IllegalArgumentException();
                }
            }

            @Override
            public String encode(Number value) {
                return value.toString();
            }

            @Override
            public T decode(String string) throws JsonValidationException {
                try {
                    return this.parser.parse(string);
                }
                catch (NumberFormatException e) {
                    throw new JsonValidationException("TODO", e);
                }
            }

            private static interface NumberParser<T extends Number> {
                public T parse(String var1) throws NumberFormatException;
            }
        };
    }
}

