/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import io.activej.common.builder.AbstractBuilder;
import io.activej.common.collection.CollectorUtils;
import io.activej.common.collection.IteratorUtils;
import io.activej.json.AbstractMapJsonCodec;
import io.activej.json.JsonCodec;
import io.activej.json.JsonConstructorN;
import io.activej.json.JsonDecoder;
import io.activej.json.JsonEncoder;
import io.activej.json.JsonFunction;
import io.activej.json.JsonSetter;
import io.activej.json.JsonValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class ObjectJsonCodec<T, A>
extends AbstractMapJsonCodec<T, A, Object> {
    private final Supplier<A> accumulatorSupplier;
    private final Field<T, A, ?>[] fields;
    private final Map<String, Field<T, A, Object>> map;
    private final JsonFunction<A, T> constructor;

    private ObjectJsonCodec(Supplier<A> accumulatorSupplier, JsonFunction<A, T> constructor, Field<T, A, Object>[] fields, Map<String, Field<T, A, Object>> map) {
        this.accumulatorSupplier = accumulatorSupplier;
        this.constructor = constructor;
        this.fields = fields;
        this.map = map;
    }

    public static <T, A> BuilderObject<T, A> builder(Supplier<A> accumulatorSupplier, JsonFunction<A, T> constructor) {
        return new BuilderObject<T, A>(accumulatorSupplier, constructor);
    }

    public static <T> BuilderArray<T> builder(JsonConstructorN<T> constructor) {
        return new BuilderArray<T>(constructor);
    }

    @Override
    protected Iterator<AbstractMapJsonCodec.JsonMapEntry<Object>> iterate(T item) {
        return IteratorUtils.transformIterator((Iterator)IteratorUtils.iteratorOf((Object[])this.fields), field -> new AbstractMapJsonCodec.JsonMapEntry(field.key, field.getter.apply(item)));
    }

    @Override
    @Nullable
    protected JsonEncoder<Object> encoder(String key, int index, T item, Object value) {
        return this.fields[index].encoderFn.encoder(key, index, item, value);
    }

    @Override
    @Nullable
    protected JsonDecoder<Object> decoder(String key, int index, A accumulator) throws JsonValidationException {
        Field<T, A, Object> field = this.map.get(key);
        if (field == null) {
            throw new JsonValidationException("Key not found: " + key);
        }
        return field.decoderFn.decoder(key, index, accumulator);
    }

    @Override
    protected A accumulator() {
        return this.accumulatorSupplier.get();
    }

    @Override
    protected void accumulate(A accumulator, String key, int index, Object value) throws JsonValidationException {
        this.map.get((Object)key).setter.set(accumulator, value);
    }

    @Override
    protected T result(A accumulator, int count) throws JsonValidationException {
        return this.constructor.apply(accumulator);
    }

    private record Field<T, A, V>(int index, String key, Function<T, V> getter, JsonSetter<A, V> setter, JsonEncoderProvider<T, V> encoderFn, JsonDecoderProvider<A, V> decoderFn) {
    }

    public static class BuilderObject<T, A>
    extends AbstractBuilder<BuilderObject<T, A>, ObjectJsonCodec<T, A>> {
        private final Supplier<A> accumulatorSupplier;
        private final JsonFunction<A, T> constructor;
        private final List<Field<T, A, Object>> fields = new ArrayList<Field<T, A, Object>>();

        public BuilderObject(Supplier<A> accumulatorSupplier, JsonFunction<A, T> constructor) {
            this.accumulatorSupplier = accumulatorSupplier;
            this.constructor = constructor;
        }

        public <V> BuilderObject<T, A> with(String key, Function<T, V> getter, JsonSetter<A, V> setter, JsonCodec<V> codec) {
            return this.with(key, getter, setter, JsonEncoderProvider.of(codec), JsonDecoderProvider.of(codec));
        }

        public <V> BuilderObject<T, A> with(String key, Function<T, V> getter, JsonSetter<A, V> setter, JsonCodecProvider<T, A, V> codecFn) {
            return this.with(key, getter, setter, codecFn, codecFn);
        }

        public <V> BuilderObject<T, A> with(String key, Function<T, V> getter, JsonSetter<A, V> setter, JsonEncoderProvider<T, V> encoderFn, JsonDecoderProvider<A, V> decoderFn) {
            Field<T, A, V> field = new Field<T, A, V>(this.fields.size(), key, getter, setter, encoderFn, decoderFn);
            this.fields.add(field);
            return this;
        }

        protected ObjectJsonCodec<T, A> doBuild() {
            return new ObjectJsonCodec<T, A>(this.accumulatorSupplier, this.constructor, (Field[])this.fields.toArray(Field[]::new), (Map)this.fields.stream().collect(CollectorUtils.toHashMap(f -> f.key, f -> f)));
        }
    }

    public static final class BuilderArray<T>
    extends AbstractBuilder<BuilderArray<T>, ObjectJsonCodec<T, Object[]>> {
        private static final Object NO_DEFAULT_VALUE = new Object();
        private final List<Field<T, Object[], Object>> fields = new ArrayList<Field<T, Object[], Object>>();
        private final JsonConstructorN<T> constructor;
        private final List<Object> prototype = new ArrayList<Object>();

        private BuilderArray(JsonConstructorN<T> constructor) {
            this.constructor = constructor;
        }

        public <V> BuilderArray<T> with(String key, Function<T, V> getter, JsonCodec<V> codec) {
            int index = this.fields.size();
            Field<T, Object[], Object> field = new Field<T, Object[], Object>(index, key, getter, (array, value) -> {
                array[index] = value;
            }, JsonEncoderProvider.of(codec), JsonDecoderProvider.of(codec));
            this.fields.add(field);
            this.prototype.add(NO_DEFAULT_VALUE);
            return this;
        }

        public <V> BuilderArray<T> with(String key, Function<T, V> getter, JsonCodec<V> codec, V defaultValue) {
            int index = this.fields.size();
            Field<Object, Object[], Object> field = new Field<Object, Object[], Object>(index, key, getter, (array, value) -> {
                array[index] = value;
            }, (key_, index_, item, value) -> Objects.equals(defaultValue, value) ? null : codec, JsonDecoderProvider.of(codec));
            this.fields.add(field);
            this.prototype.add(defaultValue);
            return this;
        }

        protected ObjectJsonCodec<T, Object[]> doBuild() {
            Object[] prototype = this.prototype.toArray(Object[]::new);
            return Arrays.stream(prototype).anyMatch(v -> v == NO_DEFAULT_VALUE) ? new ObjectJsonCodec<Object, Object[]>(() -> Arrays.copyOf(prototype, prototype.length), array -> {
                for (int i = 0; i < ((Object[])array).length; ++i) {
                    if (array[i] != NO_DEFAULT_VALUE) continue;
                    throw new JsonValidationException();
                }
                return this.constructor.create((Object[])array);
            }, (Field[])this.fields.toArray(Field[]::new), (Map)this.fields.stream().collect(CollectorUtils.toHashMap(f -> f.key, f -> f))) : new ObjectJsonCodec<Object, Object[]>(() -> new Object[prototype.length], this.constructor::create, (Field[])this.fields.toArray(Field[]::new), (Map)this.fields.stream().collect(CollectorUtils.toHashMap(f -> f.key, f -> f)));
        }
    }

    public static interface JsonEncoderProvider<T, V> {
        @Nullable
        public JsonCodec<V> encoder(String var1, int var2, T var3, V var4);

        public static <T, V> JsonEncoderProvider<T, V> of(JsonCodec<V> codec) {
            return (key, index, item, value) -> codec;
        }
    }

    public static interface JsonDecoderProvider<A, V> {
        @Nullable
        public JsonCodec<V> decoder(String var1, int var2, A var3) throws JsonValidationException;

        public static <A, V> JsonDecoderProvider<A, V> of(JsonCodec<V> codec) {
            return (key, index, accumulator) -> codec;
        }
    }

    public static interface JsonCodecProvider<T, A, V>
    extends JsonEncoderProvider<T, V>,
    JsonDecoderProvider<A, V> {
    }
}

