/*
 * Decompiled with CFR 0.152.
 */
package io.activej.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import io.activej.common.builder.AbstractBuilder;
import io.activej.json.JsonCodec;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class SubclassJsonCodec<T>
implements JsonCodec<T> {
    private final Map<String, JsonCodec<? extends T>> tagToCodec = new HashMap<String, JsonCodec<? extends T>>();
    private final Map<Class<? extends T>, String> classToTag = new HashMap<Class<? extends T>, String>();

    private SubclassJsonCodec() {
    }

    public static <T> Builder builder() {
        return new SubclassJsonCodec<T>().new Builder();
    }

    @Override
    public void write(JsonWriter writer, T value) {
        writer.writeByte((byte)123);
        String tag = this.classToTag.get(value.getClass());
        writer.writeString(tag);
        writer.writeByte((byte)58);
        JsonCodec<T> codec = this.tagToCodec.get(tag);
        codec.write(writer, value);
        writer.writeByte((byte)125);
    }

    @Override
    public T read(JsonReader<?> reader) throws IOException {
        if (reader.last() != 123) {
            throw reader.newParseError("Expected '{'");
        }
        reader.getNextToken();
        String key = reader.readKey();
        JsonCodec<T> codec = this.tagToCodec.get(key);
        if (codec == null) {
            throw reader.newParseError("Unexpected key: '" + key + "'");
        }
        T result = codec.read(reader);
        if (reader.getNextToken() != 125) {
            throw reader.newParseError("Expected '}'");
        }
        return result;
    }

    public final class Builder
    extends AbstractBuilder<Builder, SubclassJsonCodec<T>> {
        private Builder() {
        }

        public <S extends T> Builder with(Class<S> type, JsonCodec<S> codec) {
            return this.with(type, type.getSimpleName(), codec);
        }

        public <S extends T> Builder with(Class<S> type, String name, JsonCodec<S> codec) {
            SubclassJsonCodec.this.tagToCodec.put(name, codec);
            SubclassJsonCodec.this.classToTag.put(type, name);
            if (codec instanceof SubclassJsonCodec) {
                SubclassJsonCodec.this.tagToCodec.putAll(((SubclassJsonCodec)codec).tagToCodec);
                SubclassJsonCodec.this.classToTag.putAll(((SubclassJsonCodec)codec).classToTag);
            }
            return this;
        }

        protected SubclassJsonCodec<T> doBuild() {
            return SubclassJsonCodec.this;
        }
    }
}

