/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.async.service.EventloopService;
import io.activej.crdt.storage.local.CrdtStorageFs;
import io.activej.crdt.storage.local.CrdtStorageMap;
import io.activej.datastream.StreamConsumer;
import io.activej.eventloop.Eventloop;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackupService<K extends Comparable<K>, S>
implements EventloopService {
    private final Eventloop eventloop;
    private final CrdtStorageMap<K, S> inMemory;
    private final CrdtStorageFs<K, S> localFiles;
    private long lastTimestamp = 0L;
    @Nullable
    private Promise<Void> backupPromise = null;

    public BackupService(CrdtStorageMap<K, S> inMemory, CrdtStorageFs<K, S> localFiles) {
        this.inMemory = inMemory;
        this.localFiles = localFiles;
        this.eventloop = localFiles.getEventloop();
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    public Promise<Void> restore() {
        return this.localFiles.download().then(supplierWithResult -> supplierWithResult.streamTo(StreamConsumer.ofPromise((Promise)this.inMemory.upload())));
    }

    public Promise<Void> backup() {
        if (this.backupPromise != null) {
            return this.backupPromise;
        }
        long lastTimestamp = this.lastTimestamp;
        this.lastTimestamp = this.eventloop.currentTimeMillis();
        this.backupPromise = this.inMemory.download(lastTimestamp).then(supplierWithResult -> supplierWithResult.streamTo(StreamConsumer.ofPromise((Promise)this.localFiles.upload())).whenComplete(() -> {
            this.backupPromise = null;
        }));
        return this.backupPromise;
    }

    public boolean backupInProgress() {
        return this.backupPromise != null;
    }

    @NotNull
    public Promise<Void> start() {
        return this.restore().then(() -> this.localFiles.consolidate());
    }

    @NotNull
    public Promise<Void> stop() {
        return this.backup();
    }
}

