/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.config.Config;
import io.activej.config.ConfigModule;
import io.activej.config.converter.ConfigConverters;
import io.activej.crdt.CrdtServer;
import io.activej.crdt.storage.local.CrdtStorageFs;
import io.activej.eventloop.Eventloop;
import io.activej.fs.ActiveFs;
import io.activej.fs.LocalActiveFs;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.inject.module.Modules;
import io.activej.jmx.JmxModule;
import io.activej.launcher.Launcher;
import io.activej.launchers.crdt.CrdtDescriptor;
import io.activej.launchers.crdt.Initializers;
import io.activej.service.ServiceGraphModule;
import io.activej.trigger.TriggersModule;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public abstract class CrdtFileServerLauncher<K extends Comparable<K>, S>
extends Launcher {
    public static final String PROPERTIES_FILE = "crdt-file-server.properties";
    @Inject
    CrdtServer<K, S> crdtServer;

    @Provides
    Eventloop eventloop() {
        return Eventloop.create();
    }

    @Provides
    ExecutorService executor(Config config) {
        return (ExecutorService)config.get(ConfigConverters.ofExecutor(), "executor");
    }

    @Provides
    LocalActiveFs localFsClient(Eventloop eventloop, ExecutorService executor, Config config) {
        return LocalActiveFs.create((Eventloop)eventloop, (Executor)executor, (Path)((Path)config.get(ConfigConverters.ofPath(), "crdt.localPath")));
    }

    @Provides
    Config config() {
        return Config.create().overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    protected Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), JmxModule.create(), TriggersModule.create(), ConfigModule.create().withEffectiveConfigLogger(), this.getBusinessLogicModule()});
    }

    protected abstract CrdtFileServerLogicModule<K, S> getBusinessLogicModule();

    protected void run() throws Exception {
        this.awaitShutdown();
    }

    public static abstract class CrdtFileServerLogicModule<K extends Comparable<K>, S>
    extends AbstractModule {
        @Provides
        CrdtServer<K, S> crdtServer(Eventloop eventloop, CrdtStorageFs<K, S> crdtClient, CrdtDescriptor<K, S> descriptor, Config config) {
            return (CrdtServer)CrdtServer.create((Eventloop)eventloop, crdtClient, descriptor.getSerializer()).withInitializer((Consumer)io.activej.launchers.initializers.Initializers.ofAbstractServer((Config)config.getChild("crdt.server")));
        }

        @Provides
        CrdtStorageFs<K, S> fsCrdtClient(Eventloop eventloop, LocalActiveFs localFsClient, CrdtDescriptor<K, S> descriptor, Config config) {
            return (CrdtStorageFs)CrdtStorageFs.create((Eventloop)eventloop, (ActiveFs)localFsClient, descriptor.getSerializer(), descriptor.getCrdtFunction()).withInitializer(Initializers.ofFsCrdtClient(config.getChild("crdt.files")));
        }
    }
}

