/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.exception.MalformedDataException;
import io.activej.config.Config;
import io.activej.crdt.CrdtData;
import io.activej.crdt.storage.local.CrdtStorageMap;
import io.activej.crdt.util.Utils;
import io.activej.eventloop.Eventloop;
import io.activej.http.AsyncHttpServer;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpError;
import io.activej.http.HttpMethod;
import io.activej.http.HttpResponse;
import io.activej.http.RoutingServlet;
import io.activej.http.loader.StaticLoader;
import io.activej.inject.annotation.Optional;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.launchers.crdt.BackupService;
import io.activej.launchers.crdt.CrdtDescriptor;
import io.activej.launchers.initializers.Initializers;
import io.activej.promise.Promise;
import io.activej.types.TypeT;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public abstract class CrdtHttpModule<K extends Comparable<K>, S>
extends AbstractModule {
    private final TypeT<CrdtData<K, S>> crdtDataManifest = new TypeT<CrdtData<K, S>>(){};

    @Provides
    AsyncHttpServer server(Eventloop eventloop, AsyncServlet servlet, Config config) {
        return (AsyncHttpServer)AsyncHttpServer.create((Eventloop)eventloop, (AsyncServlet)servlet).withInitializer((Consumer)Initializers.ofHttpServer((Config)config.getChild("crdt.http")));
    }

    @Provides
    StaticLoader loader(Executor executor) {
        return StaticLoader.ofClassPath((Executor)executor, (String)"/");
    }

    @Provides
    AsyncServlet servlet(CrdtDescriptor<K, S> descriptor, CrdtStorageMap<K, S> client, @Optional BackupService<K, S> backupService) {
        RoutingServlet servlet = RoutingServlet.create().map(HttpMethod.POST, "/", request -> request.loadBody().map(body -> {
            try {
                Comparable key = (Comparable)Utils.fromJson((Type)descriptor.getKeyManifest(), (ByteBuf)body);
                Object state = client.get(key);
                if (state != null) {
                    return HttpResponse.ok200().withBody(Utils.toJson((Type)descriptor.getStateManifest(), (Object)state));
                }
                return HttpResponse.ofCode((int)404).withBody(("Key '" + key + "' not found").getBytes(StandardCharsets.UTF_8));
            }
            catch (MalformedDataException e) {
                throw HttpError.ofCode((int)400, (Exception)((Object)e));
            }
        })).map(HttpMethod.PUT, "/", request -> request.loadBody().map(body -> {
            try {
                client.put((CrdtData)Utils.fromJson((Type)this.crdtDataManifest.getType(), (ByteBuf)body));
                return HttpResponse.ok200();
            }
            catch (MalformedDataException e) {
                throw HttpError.ofCode((int)400, (Exception)((Object)e));
            }
        })).map(HttpMethod.DELETE, "/", request -> request.loadBody().map(body -> {
            try {
                Comparable key = (Comparable)Utils.fromJson((Type)descriptor.getKeyManifest(), (ByteBuf)body);
                if (client.remove(key)) {
                    return HttpResponse.ok200();
                }
                return HttpResponse.ofCode((int)404).withBody(("Key '" + key + "' not found").getBytes(StandardCharsets.UTF_8));
            }
            catch (MalformedDataException e) {
                throw HttpError.ofCode((int)400, (Exception)((Object)e));
            }
        }));
        if (backupService == null) {
            return servlet;
        }
        return servlet.map(HttpMethod.POST, "/backup", request -> {
            if (backupService.backupInProgress()) {
                return Promise.of((Object)HttpResponse.ofCode((int)403).withBody("Backup is already in progress".getBytes(StandardCharsets.UTF_8)));
            }
            backupService.backup();
            return Promise.of((Object)HttpResponse.ofCode((int)202));
        }).map(HttpMethod.POST, "/awaitBackup", request -> backupService.backupInProgress() ? backupService.backup().map($ -> HttpResponse.ofCode((int)204).withBody("Finished already running backup".getBytes(StandardCharsets.UTF_8))) : backupService.backup().map($ -> HttpResponse.ok200()));
    }
}

