/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.config.Config;
import io.activej.config.converter.ConfigConverters;
import io.activej.crdt.function.CrdtFunction;
import io.activej.crdt.util.CrdtDataSerializer;
import io.activej.crdt.util.TimestampContainer;
import io.activej.eventloop.Eventloop;
import io.activej.fs.ActiveFs;
import io.activej.fs.LocalActiveFs;
import io.activej.http.AsyncHttpServer;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.launchers.crdt.CrdtDescriptor;
import io.activej.launchers.crdt.CrdtHttpModule;
import io.activej.launchers.crdt.CrdtNodeLauncher;
import io.activej.launchers.crdt.CrdtNodeLogicModule;
import io.activej.serializer.BinarySerializer;
import io.activej.serializer.BinarySerializers;
import io.activej.types.TypeT;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class CrdtNodeExample
extends CrdtNodeLauncher<String, TimestampContainer<Integer>> {
    @Inject
    AsyncHttpServer httpServer;

    @Override
    protected CrdtNodeLogicModule<String, TimestampContainer<Integer>> getBusinessLogicModule() {
        return new CrdtNodeLogicModule<String, TimestampContainer<Integer>>(){

            @Override
            protected void configure() {
                this.install((Module)new CrdtHttpModule<String, TimestampContainer<Integer>>(){});
            }

            @Provides
            CrdtDescriptor<String, TimestampContainer<Integer>> descriptor() {
                return new CrdtDescriptor<String, TimestampContainer<Integer>>((CrdtFunction<TimestampContainer<Integer>>)TimestampContainer.createCrdtFunction(Integer::max), (CrdtDataSerializer<String, TimestampContainer<Integer>>)new CrdtDataSerializer(BinarySerializers.UTF8_SERIALIZER, TimestampContainer.createSerializer((BinarySerializer)BinarySerializers.INT_SERIALIZER)), (Type)((Object)String.class), new TypeT<TimestampContainer<Integer>>(){}.getType());
            }

            @Provides
            Executor provideExecutor(Config config) {
                return (Executor)config.get(ConfigConverters.ofExecutor(), "crdt.local.executor", (Object)Executors.newSingleThreadExecutor());
            }

            @Provides
            ActiveFs fs(Eventloop eventloop, Executor executor, Config config) {
                return LocalActiveFs.create((Eventloop)eventloop, (Executor)executor, (Path)((Path)config.get(ConfigConverters.ofPath(), "crdt.local.path")));
            }
        };
    }

    protected Module getOverrideModule() {
        return new AbstractModule(){

            @Provides
            Config config() {
                return Config.create().with("crdt.http.listenAddresses", "localhost:8080").with("crdt.server.listenAddresses", "localhost:9090").with("crdt.local.path", "/tmp/TESTS/crdt").with("crdt.cluster.localPartitionId", "local").with("crdt.cluster.partitions.noop", "localhost:9091").with("crdt.cluster.server.listenAddresses", "localhost:9000").overrideWith(Config.ofClassPathProperties((String)"crdt-node.properties", (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
            }
        };
    }

    public static void main(String[] args) throws Exception {
        CrdtNodeExample launcher = new CrdtNodeExample();
        launcher.launch(args);
    }
}

