/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.config.Config;
import io.activej.config.ConfigModule;
import io.activej.crdt.CrdtServer;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.Module;
import io.activej.inject.module.Modules;
import io.activej.jmx.JmxModule;
import io.activej.launcher.Launcher;
import io.activej.launchers.crdt.CrdtNodeLogicModule;
import io.activej.service.ServiceGraphModule;
import io.activej.trigger.TriggersModule;

public abstract class CrdtNodeLauncher<K extends Comparable<K>, S>
extends Launcher {
    public static final String PROPERTIES_FILE = "crdt-node.properties";
    @Inject
    @CrdtNodeLogicModule.Cluster
    CrdtServer<K, S> clusterServer;
    @Inject
    CrdtServer<K, S> crdtServer;

    @Provides
    Config config() {
        return Config.create().overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    protected Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), JmxModule.create(), TriggersModule.create(), ConfigModule.create().withEffectiveConfigLogger(), this.getBusinessLogicModule()});
    }

    protected abstract CrdtNodeLogicModule<K, S> getBusinessLogicModule();

    protected void run() throws Exception {
        this.awaitShutdown();
    }
}

