/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt;

import io.activej.common.Checks;
import io.activej.config.Config;
import io.activej.config.converter.ConfigConverters;
import io.activej.crdt.CrdtServer;
import io.activej.crdt.CrdtStorageClient;
import io.activej.crdt.storage.CrdtStorage;
import io.activej.crdt.storage.cluster.CrdtPartitions;
import io.activej.crdt.storage.cluster.CrdtRepartitionController;
import io.activej.crdt.storage.cluster.CrdtStorageCluster;
import io.activej.crdt.storage.cluster.DiscoveryService;
import io.activej.crdt.storage.local.CrdtStorageFs;
import io.activej.crdt.storage.local.CrdtStorageMap;
import io.activej.eventloop.Eventloop;
import io.activej.fs.ActiveFs;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.QualifierAnnotation;
import io.activej.inject.module.AbstractModule;
import io.activej.launchers.crdt.CrdtDescriptor;
import io.activej.launchers.crdt.Initializers;
import io.activej.types.Types;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class CrdtNodeLogicModule<K extends Comparable<K>, S>
extends AbstractModule {
    protected void configure() {
        Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] typeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        @NotNull ParameterizedType supertype = Types.parameterizedType(CrdtStorage.class, (Type[])typeArguments);
        this.bind(Key.ofType((Type)supertype, InMemory.class)).to(Key.ofType((Type)Types.parameterizedType(CrdtStorageMap.class, (Type[])typeArguments)));
        this.bind(Key.ofType((Type)supertype, Persistent.class)).to(Key.ofType((Type)Types.parameterizedType(CrdtStorageFs.class, (Type[])typeArguments)));
        Type[] clusterStorageTypes = Arrays.copyOf(typeArguments, 3);
        clusterStorageTypes[2] = String.class;
        this.bind(Key.ofType((Type)supertype, Cluster.class)).to(Key.ofType((Type)Types.parameterizedType(CrdtStorageCluster.class, (Type[])clusterStorageTypes)));
    }

    @Provides
    CrdtStorageMap<K, S> runtimeCrdtClient(Eventloop eventloop, CrdtDescriptor<K, S> descriptor) {
        return CrdtStorageMap.create((Eventloop)eventloop, descriptor.getCrdtFunction());
    }

    @Provides
    CrdtStorageFs<K, S> fsCrdtClient(Eventloop eventloop, Config config, ActiveFs activeFs, CrdtDescriptor<K, S> descriptor) {
        return (CrdtStorageFs)CrdtStorageFs.create((Eventloop)eventloop, (ActiveFs)activeFs, descriptor.getSerializer(), descriptor.getCrdtFunction()).withInitializer(Initializers.ofFsCrdtClient(config));
    }

    @Provides
    DiscoveryService<K, S, String> discoveryService(CrdtStorageMap<K, S> localClient, CrdtDescriptor<K, S> descriptor, Config config) {
        config = config.getChild("crdt.cluster");
        Eventloop eventloop = localClient.getEventloop();
        HashMap<String, Object> partitions = new HashMap<String, Object>();
        partitions.put(config.get("localPartitionId"), localClient);
        Map partitionsConfigmap = config.getChild("partitions").getChildren();
        Checks.checkState((!partitionsConfigmap.isEmpty() ? 1 : 0) != 0, (Object)"Cluster could not operate without partitions, config had none");
        for (Map.Entry entry : partitionsConfigmap.entrySet()) {
            InetSocketAddress address = (InetSocketAddress)ConfigConverters.ofInetSocketAddress().get((Config)entry.getValue());
            partitions.put((String)entry.getKey(), CrdtStorageClient.create((Eventloop)eventloop, (InetSocketAddress)address, descriptor.getSerializer()));
        }
        return DiscoveryService.constant(partitions);
    }

    @Provides
    CrdtPartitions<K, S, String> partitions(Eventloop eventloop, DiscoveryService<K, S, String> discoveryService) {
        return CrdtPartitions.create((Eventloop)eventloop, discoveryService);
    }

    @Provides
    CrdtStorageCluster<K, S, String> clusterCrdtClient(CrdtPartitions<K, S, String> partitions, CrdtDescriptor<K, S> descriptor, Config config) {
        return CrdtStorageCluster.create(partitions, descriptor.getCrdtFunction()).withReplicationCount(((Integer)config.get(ConfigConverters.ofInteger(), "crdt.cluster.replicationCount", (Object)1)).intValue());
    }

    @Provides
    CrdtRepartitionController<K, S, String> crdtRepartitionController(CrdtStorageCluster<K, S, String> clusterClient, Config config) {
        return CrdtRepartitionController.create(clusterClient, (Comparable)((Object)config.get("crdt.cluster.localPartitionId")));
    }

    @Provides
    CrdtServer<K, S> crdtServer(Eventloop eventloop, CrdtStorageMap<K, S> client, CrdtDescriptor<K, S> descriptor, Config config) {
        return (CrdtServer)CrdtServer.create((Eventloop)eventloop, client, descriptor.getSerializer()).withInitializer((Consumer)io.activej.launchers.initializers.Initializers.ofAbstractServer((Config)config.getChild("crdt.server")));
    }

    @Provides
    @Cluster
    CrdtServer<K, S> clusterServer(Eventloop eventloop, CrdtStorageCluster<K, S, String> client, CrdtDescriptor<K, S> descriptor, Config config) {
        return (CrdtServer)CrdtServer.create((Eventloop)eventloop, client, descriptor.getSerializer()).withInitializer((Consumer)io.activej.launchers.initializers.Initializers.ofAbstractServer((Config)config.getChild("crdt.cluster.server")));
    }

    @Provides
    Eventloop eventloop(Config config) {
        return (Eventloop)Eventloop.create().withInitializer((Consumer)io.activej.launchers.initializers.Initializers.ofEventloop((Config)config));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @QualifierAnnotation
    public static @interface Cluster {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @QualifierAnnotation
    public static @interface Persistent {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @QualifierAnnotation
    public static @interface InMemory {
    }
}

