/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt.rpc;

import io.activej.common.Checks;
import io.activej.config.Config;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.ConfigConverters;
import io.activej.eventloop.Eventloop;
import io.activej.inject.annotation.Optional;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.rpc.client.RpcClient;
import io.activej.rpc.client.sender.RpcStrategies;
import io.activej.rpc.client.sender.RpcStrategy;
import io.activej.rpc.client.sender.RpcStrategyList;
import io.activej.rpc.hash.ShardingFunction;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;

public class CrdtRpcClientModule
extends AbstractModule {
    public static final String PROPERTIES_FILE = "crdt-rpc-client.properties";

    @Provides
    Eventloop eventloop() {
        return Eventloop.create();
    }

    @Provides
    Config config() {
        return Config.create().with("address", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(9000))).overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    @Provides
    RpcClient client(Eventloop eventloop, RpcStrategy strategy, List<Class<?>> messageTypes) {
        return RpcClient.create((Eventloop)eventloop).withMessageTypes(messageTypes).withStrategy(strategy);
    }

    @Provides
    RpcStrategy strategy(Config config, @Optional ShardingFunction<?> shardingFn) {
        List addresses = (List)config.get(ConfigConverters.ofList((ConfigConverter)ConfigConverters.ofInetSocketAddress()), "addresses", Collections.emptyList());
        if (addresses.isEmpty()) {
            InetSocketAddress address = (InetSocketAddress)config.get(ConfigConverters.ofInetSocketAddress(), "address");
            return RpcStrategies.server((InetSocketAddress)address);
        }
        return RpcStrategies.sharding((ShardingFunction)((ShardingFunction)Checks.checkNotNull(shardingFn)), (RpcStrategyList)RpcStrategyList.ofAddresses((List)addresses));
    }
}

