/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.crdt.rpc;

import io.activej.async.service.EventloopTaskScheduler;
import io.activej.config.Config;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.ConfigConverters;
import io.activej.crdt.wal.WriteAheadLog;
import io.activej.eventloop.Eventloop;
import io.activej.inject.annotation.Eager;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.AbstractModule;
import io.activej.rpc.server.RpcRequestHandler;
import io.activej.rpc.server.RpcServer;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public abstract class CrdtRpcServerModule<K extends Comparable<K>, S>
extends AbstractModule {
    public static final int DEFAULT_PORT = 9000;
    public static final String PROPERTIES_FILE = "crdt-rpc-server.properties";

    protected abstract List<Class<?>> getMessageTypes();

    @Provides
    Eventloop eventloop() {
        return Eventloop.create();
    }

    @Provides
    Config config() {
        return Config.create().with("listenAddresses", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(9000))).overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    @Provides
    @Eager
    RpcServer server(Eventloop eventloop, Map<Class<?>, RpcRequestHandler<?, ?>> handlers, Config config) {
        RpcServer server = ((RpcServer)RpcServer.create((Eventloop)eventloop).withListenAddress((InetSocketAddress)config.get(ConfigConverters.ofInetSocketAddress(), "listenAddresses"))).withMessageTypes(this.getMessageTypes());
        for (Map.Entry<Class<?>, RpcRequestHandler<?, ?>> entry : handlers.entrySet()) {
            server.withHandler(entry.getKey(), entry.getValue());
        }
        return server;
    }

    @Provides
    @Eager
    EventloopTaskScheduler walFlushScheduler(Eventloop eventloop, WriteAheadLog<K, S> wal, Config config) {
        return EventloopTaskScheduler.create((Eventloop)eventloop, () -> wal.flush()).withSchedule((EventloopTaskScheduler.Schedule)config.get(ConfigConverters.ofEventloopTaskSchedule(), "flush.schedule", (Object)EventloopTaskScheduler.Schedule.ofInterval((Duration)Duration.ofMinutes(1L)))).withInitialDelay(Duration.ofMinutes(1L));
    }
}

