/*
 * Decompiled with CFR 0.152.
 */
package io.activej.multilog;

public final class LogFile
implements Comparable<LogFile> {
    private final String name;
    private final int remainder;

    public LogFile(String name, int remainder) {
        this.name = name;
        this.remainder = remainder;
    }

    @Override
    public int compareTo(LogFile o) {
        int i = this.name.compareTo(o.name);
        if (i != 0) {
            return i;
        }
        return Integer.compare(this.remainder, o.remainder);
    }

    public String getName() {
        return this.name;
    }

    public int getRemainder() {
        return this.remainder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogFile that = (LogFile)o;
        return this.remainder == that.remainder && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.remainder;
        return result;
    }

    public String toString() {
        return this.name + (this.remainder == 0 ? "" : "_" + this.remainder);
    }
}

