/*
 * Decompiled with CFR 0.152.
 */
package io.activej.multilog;

import io.activej.multilog.LogFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class LogPosition
implements Comparable<LogPosition> {
    @NotNull
    private final LogFile logFile;
    private final long position;

    private LogPosition(@NotNull LogFile logFile, long position) {
        this.logFile = logFile;
        this.position = position;
    }

    public static LogPosition create(@NotNull LogFile logFile, long position) {
        return new LogPosition(logFile, position);
    }

    public boolean isBeginning() {
        return this.position == 0L;
    }

    @NotNull
    public LogFile getLogFile() {
        return this.logFile;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPosition that = (LogPosition)o;
        if (this.position != that.position) {
            return false;
        }
        return Objects.equals(this.logFile, that.logFile);
    }

    public int hashCode() {
        return 31 * this.logFile.hashCode() + (int)(this.position ^ this.position >>> 32);
    }

    public String toString() {
        return "LogPosition{logFile=" + this.logFile + ", position=" + this.position + '}';
    }

    @Override
    public int compareTo(@NotNull LogPosition o) {
        int result = this.logFile.compareTo(o.logFile);
        return result != 0 ? result : Long.compare(this.position, o.position);
    }
}

